package editor;

import java.io.InputStream;

/**
 * Realisiert einen Editor zum Editieren von Text-Dateien.
 * 
 * Ist gem des Observer/Observable-Pattern implementiert. Werden nderungen im
 * Editor vorgenommen (neue Eingabe, abspeichern) werden die Observer darber
 * informiert.
 * 
 * @author Dietrich Boles, Uni Oldenburg
 * @version 1.0 (12.11.2008)
 * 
 */
public class TextEditor extends Editor {

	/**
	 * Erzeugt einen neuen Text-Editor; bergeben wird der Name der zu
	 * verwaltenen Datei
	 * 
	 * @param fileName
	 * @param playName
	 * @param isJava
	 */
	public TextEditor(String fileName) {
		this(fileName, null);
	}
	
	/**
	 * Erzeugt einen neuen Text-Editor; bergeben wird der Name der zu
	 * verwaltenen Datei sowie ein weiterer (bergeordneter) Name
	 * 
	 * @param fileName
	 * @param playName
	 * @param isJava
	 */
	public TextEditor(String fileName, String playName) {
		super(fileName, playName, false);
	}
	
	public TextEditor(InputStream stream, String playName) {
		super(stream, playName, false);
	}
}
