package listener;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

import model.Play;
import util.ResourceManager;
import view.DirectoryTreeNode;
import view.FilePopupMenu;

import compiler.CompileManager;

/**
 * Popup-Menu im JTree
 * 
 * @author Dietrich Boles, Uni Oldenburg
 * @version 1.0 (12.11.2008)
 * 
 */
public class FileTreePopupListener extends MouseAdapter {
	JPopupMenu dirMenu;
	JTree tree;

	public FileTreePopupListener(JPopupMenu dirMenu, JTree tree) {
		this.dirMenu = dirMenu;
		this.tree = tree;
	}

	public void mouseClicked(MouseEvent e) {
		this.maybeShowPopup(e);
	}

	public void mousePressed(MouseEvent e) {
		this.maybeShowPopup(e);
		if (e.getClickCount() == 1) {
			TreePath path = this.tree.getPathForLocation(e.getX(), e.getY());
			if (path != null) {
				Object treeComp = path.getLastPathComponent();
				Object parent = ((DefaultMutableTreeNode) treeComp).getParent();
				if (!((DefaultMutableTreeNode) treeComp).isRoot()
						&& !(treeComp instanceof DirectoryTreeNode)) {
					if (parent.toString().equals(Play.STAGE)) {
						Play play = Play.getPlay();
						if (!treeComp.toString().equals(
								play.getActiveStageName())) {
							if (CompileManager.getCompileManager()
									.isCompilationRequired()) {
								play
										.getPlayFrame()
										.getMessagePanel()
										.writeInfo(
												ResourceManager
														.getResourceManager()
														.getValue(
																"msg.stagechangecompilation"));
							} else if (play.getActivePerformance()
									.simulationRunning()) {
								play
										.getPlayFrame()
										.getMessagePanel()
										.writeInfo(
												ResourceManager
														.getResourceManager()
														.getValue(
																"msg.stagechange"));
							} else {
								this.tree.repaint();
								play.setActiveStageName(treeComp.toString());
								play
								.getPlayFrame()
								.getMessagePanel()
								.writeInfo(
										ResourceManager
												.getResourceManager()
												.getValue(
														"msg.stagechangeok"));
							}
						}
					} else if (parent.toString().equals(Play.PERFORMANCE)) {
						Play play = Play.getPlay();
						if (!treeComp.toString().equals(
								play.getActivePerformanceName())) {
							if (CompileManager.getCompileManager()
									.isCompilationRequired()) {
								play
										.getPlayFrame()
										.getMessagePanel()
										.writeInfo(
												ResourceManager
														.getResourceManager()
														.getValue(
																"msg.perfchangecompilation"));
							} else if (play.getActivePerformance()
									.simulationRunning()) {
								play
										.getPlayFrame()
										.getMessagePanel()
										.writeInfo(
												ResourceManager
														.getResourceManager()
														.getValue(
																"msg.perfchange"));
							} else {
								play.setActivePerformanceName(treeComp
										.toString());
								this.tree.repaint();
								play
								.getPlayFrame()
								.getMessagePanel()
								.writeInfo(
										ResourceManager
												.getResourceManager()
												.getValue(
														"msg.perfchangeok"));
							}
						}
					}
				}
			}
		} else if (e.getClickCount() == 2) {
			TreePath path = this.tree.getPathForLocation(e.getX(), e.getY());
			if (path != null) {
				Object treeComp = path.getLastPathComponent();
				if (!((DefaultMutableTreeNode) treeComp).isRoot()
						&& !(treeComp instanceof DirectoryTreeNode)) {
					new OpenEditorListener(e.getXOnScreen(), e.getYOnScreen())
							.open();
					Play.getPlay()
					.getPlayFrame()
					.getMessagePanel()
					.writeInfo(
							ResourceManager
									.getResourceManager()
									.getValue(
											"msg.openeditor"));
				}
			}
		}
	}

	public void mouseReleased(MouseEvent e) {
		this.maybeShowPopup(e);
	}

	private void maybeShowPopup(MouseEvent e) {
		if (e.isPopupTrigger()) {
			TreePath path = this.tree.getPathForLocation(e.getX(), e.getY());
			if (path != null) {
				Object treeComp = path.getLastPathComponent();
				if (!((DefaultMutableTreeNode) treeComp).isRoot()) {
					this.tree.setSelectionPath(path);
					if (treeComp instanceof DirectoryTreeNode) {
						this.dirMenu.show(e.getComponent(), e.getX(), e.getY());
					} else {
						FilePopupMenu fileMenu = new FilePopupMenu(this.tree);
						DefaultMutableTreeNode n = (DefaultMutableTreeNode) treeComp;
						fileMenu.show(e.getComponent(), e.getX(), e.getY(), e
								.getXOnScreen(), e.getYOnScreen(), n
								.getUserObject().toString());
					}
				}
			}
		}
	}
}
