package listener;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import javax.swing.JOptionPane;

import model.Play;
import theater_intern.TheaterObservable;
import theater_intern.TheaterObserver;
import util.ResourceManager;
import util.Utils;

/**
 * Listener zum Ausfhren einer Methode (ohne Parameter)
 * 
 * @author Dietrich Boles, Uni Oldenburg
 * @version 1.0 (12.11.2008)
 * 
 */
public class MethodInvocation implements ActionListener {

	public final static int WAIT_TIME = 5000;

	Method method;
	Object obj;
	MethodThread thread;
	ResourceManager man;

	public MethodInvocation(Method m, Object o) {
		this.method = m;
		this.obj = o;
		this.man = ResourceManager.getResourceManager();
	}

	public void actionPerformed(ActionEvent e) {
		try {
			Play.getPlay().setEventQueueActive(true);
			this.thread = new MethodThread(this);
			this.thread.start();
			this.thread.join(MethodInvocation.WAIT_TIME);
			// wenn die Ausfhrung einer Methode lnger als eine bestimmte
			// Schwelle berschreitet, wird sie abgebrochen; das verhindert
			// Endlosschleifen
			if (this.thread.isAlive()) {
				this.thread.stop();
				this.thread.join();
			} else {
				TheaterObservable.getObservable().importantStateChange();
				this.showResult();
			}
		} catch (Throwable exc) {
			exc.printStackTrace();
		} finally {
			Play.getPlay().setEventQueueActive(false);
		}
	}

	void showResult() {
		if (this.thread.result == null) {
			return;
		}
		JOptionPane.showMessageDialog(Play.getPlay().getStagePanel(),
				this.method.getName() + " "
						+ MethodInvocation.this.man.getValue("returnvalue")
						+ " " + this.thread.result.toString(),
				MethodInvocation.this.man.getValue("callmethodresult"),
				JOptionPane.INFORMATION_MESSAGE);
	}
}

class MethodThread extends Thread {

	MethodInvocation in;
	Object result;

	MethodThread(MethodInvocation in) {
		this.in = in;
	}

	public void run() {
		this.result = null;
		try {
			TheaterObservable.getObservable().setEnabled(false);
			this.result = this.in.method.invoke(this.in.obj, (Object[]) null);
			TheaterObservable.getObservable().setEnabled(true);
		} catch (InvocationTargetException exc) {
			TheaterObservable.getObservable().setEnabled(true);
			final Throwable th = exc.getTargetException();
			if (Utils.dynInstanceof(th, ThreadDeath.class)) {
				EventQueue.invokeLater(new Runnable() {
					public void run() {
						JOptionPane
								.showMessageDialog(null, ResourceManager
										.getResourceManager().getValue(
												"msg.methodcallstopped"),
										ResourceManager.getResourceManager()
												.getValue("msg.error"),
										JOptionPane.ERROR_MESSAGE);
						Play.getPlay().reset(); // alles neu laden, weil in
						// undefiniertem Zustand
					}
				});
			} else {
				EventQueue.invokeLater(new Runnable() {
					public void run() {
						JOptionPane.showMessageDialog(null, th.getMessage(), th
								.getClass().getName(),
								JOptionPane.INFORMATION_MESSAGE);
					}
				});
			}
		} catch (final Throwable exc) {
			TheaterObservable.getObservable().setEnabled(true);
			EventQueue.invokeLater(new Runnable() {
				public void run() {
					exc.printStackTrace();
					JOptionPane.showMessageDialog(Play.getPlay()
							.getStagePanel(), MethodThread.this.in.man
							.getValue("callmethoderror"), exc.getClass()
							.getName(), JOptionPane.INFORMATION_MESSAGE);
				}
			});
		}

	}

}
