package listener;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

import compiler.CompileManager;

import model.ClassManager;
import model.Play;
import util.ResourceManager;
import editor.Editor;

/**
 * Listener zum Lschen der selektierten Klasse
 * 
 * @author Dietrich Boles, Uni Oldenburg
 * @version 1.0 (12.11.2008)
 * 
 */
public class RemoveClassListener implements ActionListener {

	private JTree fileTree;
	private Play play;

	public RemoveClassListener(JTree tree) {
		this.fileTree = tree;
		this.play = null;
	}

	public void actionPerformed(ActionEvent e) {
		this.play = Play.getPlay();
		JTree fileTree = this.play.getPlayFrame().getFileTree();
		DefaultMutableTreeNode node = (DefaultMutableTreeNode) fileTree
				.getLastSelectedPathComponent();
		String fileName = node.getUserObject().toString();
		java.awt.Component parent = Play.getPlay().getPlayFrame();

		int answer = JOptionPane.showConfirmDialog(parent, ResourceManager
				.getResourceManager().getValue("msg.removerequest1")
				+ " \""
				+ fileName
				+ "\" "
				+ ResourceManager.getResourceManager().getValue(
						"msg.removerequest2"), ResourceManager
				.getResourceManager().getValue("msg.request"),
				JOptionPane.YES_NO_OPTION);
		if (answer == JOptionPane.YES_OPTION) {
			this.remove();
			CompileManager.getCompileManager().setCompilationRequired(true);
			this.play.getPlayFrame().getMessagePanel().writeInfo(
					ResourceManager.getResourceManager().getValue("msg.removeclass"));
		}
	}

	public void remove() {
		this.play = Play.getPlay();
		JTree fileTree = this.play.getPlayFrame().getFileTree();
		DefaultMutableTreeNode node = (DefaultMutableTreeNode) fileTree
				.getLastSelectedPathComponent();
		String fileName = node.getUserObject().toString();

		// Editor schlieen
		Editor editor = ClassManager.getClassManager().getClass(fileName)
				.getEditor();
		editor.close();

		// Dateien lschen
		File file = new File(this.play.getDirectory() + File.separatorChar
				+ fileName + ".class");
		file.delete();
		file = new File(this.play.getDirectory() + File.separatorChar
				+ fileName + ".java");
		file.delete();

		// aus internen Datenstrukturen entfernen
		TreePath currentSelection = fileTree.getSelectionPath();
		if (currentSelection != null) {
			DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode) currentSelection
					.getLastPathComponent();
			MutableTreeNode parent = (MutableTreeNode) currentNode.getParent();
			if (parent != null) {
				if (parent.toString().equals(Play.STAGE)) {
					String className = currentNode.toString();
					this.play.removeStageClass(currentNode.toString());
					if (className.equals(this.play.getActiveStageName())) {
						if (this.play.getStageClasses().size() > 0) {
							this.play.setActiveStageName(this.play
									.getStageClasses().get(0));
							this.play.reset();
						} else {
							this.play.setActiveStageName(null);
						}
					}
				} else if (parent.toString().equals(Play.ACTOR)) {
					this.play.removeActorClass(currentNode.toString());
				} else if (parent.toString().equals(Play.PROP)) {
					this.play.removePropClass(currentNode.toString());
				} else if (parent.toString().equals(Play.PERFORMANCE)) {
					String className = currentNode.toString();
					this.play.removePerformanceClass(currentNode.toString());
					if (className.equals(this.play.getActivePerformanceName())) {
						// setze DefaultPerformance
						this.play.setActivePerformanceName(null);
					}
				} else if (parent.toString().equals(Play.OTHER)) {
					this.play.removeOtherClass(currentNode.toString());
				}

				((DefaultTreeModel) this.fileTree.getModel())
						.removeNodeFromParent(currentNode);
			}
		}
	}
}
