package listener;

import java.io.File;
import java.io.IOException;

import javax.swing.JOptionPane;

import util.PropertyManager;
import util.ResourceManager;

public class SolistApplication {

	public static void main(String[] args) {

		String[] newArgs = new String[4 + args.length];
		try {
			// choose java
			String java = "java";
			String jdk = null;
			jdk = PropertyManager.getPropertyManager().getJDK();
			if (jdk != null) {
				java = jdk + File.separatorChar + "bin" + File.separatorChar
						+ "java";
			}

			newArgs[0] = java;
			newArgs[1] = "-splash:splashscreen.png";
			newArgs[2] = "-jar";
			newArgs[3] = Application.JAR_NAME;
			for (int i = 0; i < args.length; i++) {
				newArgs[4 + i] = args[i];
			}

			ProcessBuilder builder = new ProcessBuilder(newArgs);
			builder.start();
		} catch (IOException exc) {
			String msg = "";
			for (String s : newArgs) {
				msg = msg + s + " ";
			}
			JOptionPane.showMessageDialog(null, ResourceManager
					.getResourceManager().getValue("starterror")
					+ msg, ResourceManager.getResourceManager().getValue(
					"msg.error"), JOptionPane.ERROR_MESSAGE);
		}
	}
}
