package theater_intern;

import java.util.Observable;
import java.util.Observer;

import model.Play;

/**
 * 
 * @author Dietrich Boles, Uni Oldenburg
 * @version 1.0 (12.11.2008)
 * 
 */
public class TheaterObserver implements Observer {

	private static TheaterObserver observer = null;

	static {
		observer = new TheaterObserver();
	}
	
	public static void reinit() {
		observer = new TheaterObserver();
	}

	/**
	 * Liefert den aktuellen Theater-Observer
	 * 
	 * @return
	 */
	public static TheaterObserver getObserver() {
		return observer;
	}

	/**
	 * Setzt den aktuellen TheaterObserver
	 * 
	 * @param observer
	 */
	public static void setObserver(TheaterObserver ob) {
		TheaterObservable.getObservable().deleteObserver(observer);
		TheaterObserver.observer = ob;
	}

	protected TheaterObserver() {
		TheaterObservable.getObservable().addObserver(this);
	}

	public void update(Observable o, Object arg) {
		if (Play.getPlay().getStagePanel() != null) {
			Play.getPlay().getStagePanel().repaintStage();
		}
	}
}
