package data;

import theater.Stage;


/**
 * represents a I tetromino
 *
 * @author Dietrich Boles (University of Oldenburg, Germany)
 * @version 1.0 (17.12.2008)
 *
 */
public class ITetromino extends Tetromino {
    ITetromino() {
        super("red");
    }

    public void addedToStage(Stage stage) {
        direction = genDirection();

        int start = genStartX();

        for (int i = 0; i < 4; i++) {
            getStage().add(b[i], start + i, 2);
        }

        setDirection();
    }

    protected void setDirection() {
        switch (direction) {
        case NORTH:
        case SOUTH:

            for (int i = 0; i < 4; i++) {
                if (i == 1) {
                    continue;
                }

                b[i].setLocation(b[1].getColumn(), (b[1].getRow() + 1) - i);
            }

            break;

        case WEST:
        case EAST:

            for (int i = 0; i < 4; i++) {
                if (i == 1) {
                    continue;
                }

                b[i].setLocation(b[1].getColumn() - 1 + i, b[1].getRow());
            }

            break;
        }
    }

    protected Block leftMost() {
        return b[0];
    }

    protected Block rightMost() {
        return b[3];
    }

    protected boolean turnPossible() {
        switch (direction) {
        case NORTH:
        case SOUTH:
            return (b[0].getColumn() >= 1) &&
            (b[3].getColumn() <= (TetrisWorld.getWorld().getNumberOfColumns() -
            3));

        default: // EAST, WEST

            return b[0].getRow() < (TetrisWorld.getWorld().getNumberOfRows() -
            3);
        }
    }

    protected int genStartX() {
        return (int) (Math.random() * (TetrisWorld.getWorld()
                                                  .getNumberOfColumns() - 3));
    }
}
