package editor;

import java.util.Iterator;
import java.util.LinkedList;

import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

/**
 * Speziell fr Text-Editoren entwickeltes Document.
 * 
 * @author Dietrich Boles, Uni Oldenburg
 * @version 1.0 (12.11.2008)
 * 
 */
public class TextDocument extends JavaDocument implements DocumentListener {
	boolean highlighting;

	public TextDocument(Editor editor, EditorPanel panel) {
		super(editor, panel);
		this.scanner = null;
	}

	public void removeDocListener() {
		this.removeDocumentListener(this);
	}

	public void addDocListener() {
		this.addDocumentListener(this);
		SwingUtilities
				.invokeLater(new RunRehighlight(0, this.getLength(), this));
	}

	JavaToken first() {
		return this.tokens.getFirst();
	}

	int copyAllBefore(int pos, LinkedList<JavaToken> newTokens) {
		int start = 0;
		while (!this.tokens.isEmpty()
				&& this.first().getStart() + this.first().getText().length() < pos) {
			start = this.first().getStart() + this.first().getText().length();
			newTokens.addLast(this.tokens.removeFirst());
		}
		return start;
	}

	public JavaToken getTokenAt(int pos) {
		for (Iterator<JavaToken> iter = this.tokens.iterator(); iter.hasNext();) {
			JavaToken token = iter.next();
			if (token.getStart() >= pos) {
				return token;
			}
		}
		return null;
	}

	boolean exists(JavaToken t, int offset) {
		while (!this.tokens.isEmpty()) {
			if (this.first().getStart() + offset == t.getStart()) {
				return true;
			} else if (this.first().getStart() + offset < t.getStart()) {
				this.tokens.removeFirst();
			} else {
				return false;
			}
		}
		return false;
	}

	void copyAllAfter(LinkedList<JavaToken> newTokens, int offset) {
		while (!this.tokens.isEmpty()) {
			JavaToken t = this.first();
			t.setStart(t.getStart() + offset);
			newTokens.addLast(this.tokens.removeFirst());
		}
	}

	void setAttributes(JavaToken t) {
		if (t.getType() == JavaLexer.COMMENT) {
			this.setCharacterAttributes(t.getStart(), t.getText().length(),
					this.getStyle("comment"), true);
		} else if (t.getType() == JavaLexer.KEYWORD) {
			this.setCharacterAttributes(t.getStart(), t.getText().length(),
					this.getStyle("keyword"), true);
		} else if (t.getType() == JavaLexer.LITERAL) {
			this.setCharacterAttributes(t.getStart(), t.getText().length(),
					this.getStyle("literal"), true);
		} else {
			this.setCharacterAttributes(t.getStart(), t.getText().length(),
					this.getStyle("plain"), true);
		}
	}

	public boolean isHighlighting() {
		return this.highlighting;
	}

	public void rehighlight(int pos, int len) {
	}

	public void changedUpdate(DocumentEvent e) {
	}

	public void insertUpdate(DocumentEvent e) {
		SwingUtilities.invokeLater(new RunRehighlight(e.getOffset(), e
				.getLength(), this));
	}

	public void removeUpdate(DocumentEvent e) {
		SwingUtilities.invokeLater(new RunRehighlight(e.getOffset(), -e
				.getLength(), this));
	}
}