package listener;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Collection;

import javax.swing.JOptionPane;

import model.ClassManager;
import model.Play;
import model.TheaterClass;
import util.ResourceManager;

/**
 * Listener Beenden von Theater
 * 
 * @author Dietrich Boles, Uni Oldenburg
 * @version 1.0 (12.11.2008)
 * 
 */
public class QuitListener implements ActionListener {

	public void actionPerformed(ActionEvent e) {
		QuitListener.quit();
	}

	public static void quit() {
		Play play = Play.getPlay();
		if (!play.isEmpty() && !Application.isStandAlone()) {
			play.save();

			boolean allSaved = true;
			String files = "";
			Collection<TheaterClass> coll = ClassManager.getClassManager()
					.getAllClasses();
			for (TheaterClass cls : coll) {
				if (!cls.getEditor().isSaved()) {
					allSaved = false;
					if (!files.equals("")) {
						files = files + ", ";
					}
					files = files + cls.getName() + ".java";
				}
			}
			files = files + ".";
			if (!play.isEmpty() && !allSaved) {
				int n = JOptionPane.showConfirmDialog(play.getPlayFrame(),
						ResourceManager.getResourceManager().getValue(
								"msg.saverequest1")
								+ "\n"
								+ files
								+ "\n"
								+ ResourceManager.getResourceManager()
										.getValue("msg.saverequest2"),
						ResourceManager.getResourceManager().getValue(
								"msg.request"),
						JOptionPane.YES_NO_CANCEL_OPTION);
				if (n == JOptionPane.YES_OPTION) {

					try {
						play.getInfoEditor().save();
					} catch (IOException exc) {
						exc.printStackTrace();
					}
					Collection<TheaterClass> cls = ClassManager
							.getClassManager().getAllClasses();
					for (TheaterClass c : cls) {
						try {
							c.getEditor().save();
						} catch (IOException exc) {
							exc.printStackTrace();
						}
					}
				} else if (n == JOptionPane.NO_OPTION) {
					// nothing
				} else {
					return;
				}
			}
		}
		System.exit(0);
	}

}
