package simulation.listener;

import theater.Component;
import theater.KeyInfo;
import theater.Stage;

public class KeyPressedObject extends EventObject {

	public KeyPressedObject(Component comp, KeyInfo keyInfo) {
		super(comp, keyInfo);
	}

	public KeyPressedObject(Stage stage, KeyInfo keyInfo) {
		super(stage, keyInfo);
	}

	public void call() {
		KeyInfo eventInfo = (KeyInfo)this.eventInfo;
		if (comp != null) {
			if (comp.isHandlingKeyEvents() && !eventInfo.isConsumed()) {
				comp.keyPressed(eventInfo);
			}
		} else {
			if (stage.isHandlingKeyEvents() && !eventInfo.isConsumed()) {
				stage.keyPressed(eventInfo);
			}
		}
	}
}
