package simulation.listener;

import theater.Component;
import theater.MouseInfo;
import theater.Stage;

public class MouseEnteredObject extends EventObject {

	public MouseEnteredObject(Component comp, MouseInfo mouseInfo) {
		super(comp, mouseInfo);
	}

	public MouseEnteredObject(Stage stage, MouseInfo mouseInfo) {
		super(stage, mouseInfo);
	}

	public void call() {
		MouseInfo eventInfo = (MouseInfo) this.eventInfo;
		if (comp != null) {
			if (comp.isHandlingMouseEvents() && !eventInfo.isConsumed()) {
				comp.mouseEntered(eventInfo);
			}
		} else {
			if (stage.isHandlingMouseEvents() && !eventInfo.isConsumed()) {
				stage.mouseEntered(eventInfo);
			}
		}
	}
}
