package theater;

/**
 * Die Klasse Actor ist die Basisklasse aller Akteure. Sie erbt alle Methoden
 * ihrer Oberklasse Component.
 * <p>
 * </p>
 * Soll ein neuer Akteur definiert werden, muss eine entsprechende Klasse von
 * der Klasse Actor abgeleitet und die Methode "public void run()" berschrieben
 * werden. In dieser wird das Eigenleben von Akteuren der Klasse festgelegt,
 * wobei u. a. die geerbten Methoden der Klasse Component genutzt werden knnen.
 * 
 * @author Dietrich Boles, Universitt Oldenburg, Germany
 * @version 1.0 (08.09.2009)
 * 
 */
public class Actor extends Component {

	/**
	 * Default-Prioritt eines Akteurs
	 */
	public final static int DEF_PRIORITY = 0;

	/**
	 * Default-Konstruktor der Klasse Actor
	 */
	public Actor() {
		super(true);
	}

	/**
	 * Muss berschrieben werden und die Actor-spezifischen Aktionen enthalten
	 * 
	 * @see theater.Component#run()
	 */
	public void run() {
	}

	/**
	 * Ordnet dem Akteur eine neue Prioritt zu. Diese spielt bei der Ausfhrung
	 * der run-Methoden eine Rolle. Je hher die Prioritt eines Akteurs ist,
	 * desto eher wird seine run-Methode aufgerufen. Bei Akteuren gleicher
	 * Prioritt ist die Reihenfolge der Ausfhrung unbestimmt.
	 * 
	 * @param priority
	 *            die Prioritt
	 */
	final public void setPriority(int priority) {
		this.comp.setPriority(priority);
	}

	/**
	 * Liefert die Prioritt des Akteurs
	 * 
	 * @return die Prioritt des Akteurs
	 */
	final public int getPriority() {
		return this.comp.getPriority();
	}
}
