package view;

import java.awt.Color;
import java.awt.Component;

import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

import model.ClassManager;
import model.Play;
import model.TheaterClass;
import util.ResourceLoader;

/**
 * Renderer einer Klasse im JTree
 * 
 * @author Dietrich Boles, Uni Oldenburg
 * @version 1.0 (12.11.2008)
 * 
 */
public class FileTreeCellRenderer extends DefaultTreeCellRenderer {

	public Component getTreeCellRendererComponent(JTree tree, Object value,
			boolean sel, boolean expanded, boolean leaf, int row,
			boolean hasFocus) {

		super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf,
				row, hasFocus);
		DefaultMutableTreeNode node = (DefaultMutableTreeNode) value;
		DefaultMutableTreeNode parent = (DefaultMutableTreeNode) node
				.getParent();
		TheaterClass cls = ClassManager.getClassManager().getClass(
				node.toString());
		if (cls == null || cls.getEditor().isSaved() || !cls.getEditor().isOpen()) {
			this.setBackgroundNonSelectionColor(tree.getBackground());
			this.setBackgroundSelectionColor(tree.getBackground());
		} else {
			this.setBackgroundNonSelectionColor(Color.LIGHT_GRAY);
			this.setBackgroundSelectionColor(Color.LIGHT_GRAY);
		}

		if (leaf) {
			if (parent.toString().equals(Play.STAGE)) {
				if (node.toString().equals(Play.getPlay().getActiveStageName())) {
					this
							.setIcon(ResourceLoader
									.getImageIcon("activestage.gif"));
				} else {
					this.setIcon(ResourceLoader.getImageIcon("stage.gif"));
				}
			} else if (parent.toString().equals(Play.ACTOR)) {
				this.setIcon(ResourceLoader.getImageIcon("actor.gif"));
			} else if (parent.toString().equals(Play.PROP)) {
				this.setIcon(ResourceLoader.getImageIcon("prop.gif"));
			} else if (parent.toString().equals(Play.PERFORMANCE)) {
				if (node.toString().equals(
						Play.getPlay().getActivePerformanceName())) {
					this.setIcon(ResourceLoader
							.getImageIcon("activeperformance.gif"));
				} else {
					this
							.setIcon(ResourceLoader
									.getImageIcon("performance.gif"));
				}
			} else if (parent.toString().equals(Play.OTHER)) {
				this.setIcon(ResourceLoader.getImageIcon("other.gif"));
			}
		}
		return this;
	}

}
