package view;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;

import javax.swing.JPanel;
import javax.swing.JWindow;

import util.ResourceLoader;

/**
 * Anfangsfenster
 * 
 * @author Dietrich Boles, Uni Oldenburg
 * @version 1.0 (12.11.2008)
 * 
 */
public class PictureFrame extends JWindow {

	public PictureFrame() {
		super();
		PicturePanel contentPanel = new PicturePanel();
		this.setContentPane(contentPanel);
		this.setSize(contentPanel.picture.getWidth(null), contentPanel.picture
				.getHeight(null));
		Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
		this.setLocation((d.width - this.getSize().width) / 2, (d.height - this
				.getSize().height) / 2);
	}
}

class PicturePanel extends JPanel {
	Image picture;

	public PicturePanel() {
		super();
		this.picture = ResourceLoader.getImage("StartPicture.png");
	}

	protected void paintComponent(Graphics g) {
		super.paintComponent(g);
		if (this.picture != null) {
			g.drawImage(this.picture, 0, 0, null);
			g.drawLine(0, 0, this.picture.getWidth(null), 0);
			g.drawLine(0, 0, 0, this.picture.getHeight(null));
			g.drawLine(0, this.picture.getHeight(null) - 1, this.picture
					.getWidth(null), this.picture.getHeight(null) - 1);
			g.drawLine(this.picture.getWidth(null) - 1, 0, this.picture
					.getWidth(null) - 1, this.picture.getHeight(null) - 2);
		}
	}
}
