package listener;

import java.awt.BorderLayout;
import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;

import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;

import model.Play;
import theater_intern.TheaterObservable;
import util.PropertyManager;
import util.ResourceManager;
import util.Utils;
import view.PictureFrame;
import view.PlayFrame;
import console.Console;

/**
 * Startet die Anwendung
 * 
 * @author Dietrich Boles, Uni Oldenburg
 * @version 1.0 (12.11.2008)
 * 
 */
public class Application {

	public final static String NEW_PLAY_OPTION = "-n";
	public final static String EXISTING_PLAY_OPTION = "-e";
	public final static String ECLIPSE_OPTION = "-eclipse";
	public final static String STANDALONE_OPTION = "-standalone";
	public final static String OOT_OPTION = "-objekttheater";
	public final static String APPLET_OPTION = "-applet";
	public final static String JAR_NAME = "objekttheater.jar";

	public final static String STANDALONE_JAR_NAME = "performance.jar";

	private static String[] args;

	public static void main(String[] args) {

		Application.args = args;
		if (!isStandAlone() && !checkJDK()) {
			chooseJDK();
			System.exit(0);
		}

		try {
			EventQueue.invokeAndWait(new MainThread(args));
		} catch (InterruptedException e) {
			Utils.handleInternalError(e);
		} catch (InvocationTargetException e) {
			Utils.handleInternalError(e);
		}
	}

	public static boolean checkJDK() {
		JavaCompiler javac = ToolProvider.getSystemJavaCompiler();
		return javac != null;
	}

	public static void chooseJDK() {
		String jdk = null;
		jdk = PropertyManager.getPropertyManager().getJDK();
		if (jdk != null) {
			String[] newArgs = new String[args.length + 3];
			newArgs[0] = jdk + File.separatorChar + "bin" + File.separatorChar
					+ "java";
			newArgs[1] = "-jar";
			newArgs[2] = Application.JAR_NAME;
			for (int i = 0; i < args.length; i++) {
				newArgs[3 + i] = args[i];
			}
			try {
				ProcessBuilder builder = new ProcessBuilder(newArgs);
				builder.start();
				PropertyManager.getPropertyManager().setJDK(jdk);
				return;
			} catch (IOException exc) {
				JOptionPane.showMessageDialog(null, ResourceManager
						.getResourceManager().getValue("jdkchooser.msg3"),
						ResourceManager.getResourceManager().getValue(
								"jdkchooser.title"), JOptionPane.ERROR_MESSAGE);
				jdk = null;
			}
		}
		while (jdk == null) {
			JOptionPane.showMessageDialog(null, ResourceManager
					.getResourceManager().getValue("jdkchooser.msg"),
					ResourceManager.getResourceManager().getValue(
							"jdkchooser.title"), JOptionPane.PLAIN_MESSAGE);
			JFileChooser chooser = new JFileChooser();
			chooser.setAcceptAllFileFilterUsed(false);
			chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
			int returnVal = chooser.showDialog(null, ResourceManager
					.getResourceManager()
					.getValue("filechooser.jdk.buttontext"));
			if (returnVal != JFileChooser.APPROVE_OPTION) {
				return;
			}
			File dir = chooser.getSelectedFile();
			jdk = dir.getAbsolutePath();

			String[] newArgs = new String[args.length + 3];
			newArgs[0] = jdk + File.separatorChar + "bin" + File.separatorChar
					+ "java";
			newArgs[1] = "-jar";
			newArgs[2] = Application.JAR_NAME;
			for (int i = 0; i < args.length; i++) {
				newArgs[3 + i] = args[i];
			}
			try {
				ProcessBuilder builder = new ProcessBuilder(newArgs);
				builder.start();
				PropertyManager.getPropertyManager().setJDK(jdk);
			} catch (IOException exc) {
				JOptionPane.showMessageDialog(null, ResourceManager
						.getResourceManager().getValue("jdkchooser.msg2"),
						ResourceManager.getResourceManager().getValue(
								"jdkchooser.title"), JOptionPane.ERROR_MESSAGE);
				jdk = null;
			}
		}
	}

	public static void openPlay(File playDescFile) {
		Play play = new Play(playDescFile);
		JFrame frame = play.getPlayFrame();
		TheaterObservable.getObservable().importantStateChange();
		frame.setVisible(true);
	}

	public static void openStandAlonePlay(String playDescFile) {
		Play play = new Play(playDescFile, true);
		JFrame frame = play.getPlayFrame();
		TheaterObservable.getObservable().importantStateChange();
		if (!Application.isApplet()) {
			frame.setVisible(true);
		}
	}

	public static void openEmptyPlay() {
		Play play = new Play();
		PlayFrame frame = play.getPlayFrame();
		frame.setVisible(true);
		frame.getMessagePanel()
				.writeInfo(
						ResourceManager.getResourceManager().getValue(
								"msg.emptystart"));
	}

	public static void openNewPlay(String dirName) {
		Play play = new Play(dirName);
		JFrame frame = play.getPlayFrame();
		frame.setVisible(true);
	}

	static boolean newPlayOption(String[] args) {
		if (args == null) {
			return false;
		}
		for (String str : args) {
			if (str.equals(Application.NEW_PLAY_OPTION)) {
				return true;
			}
		}
		return false;
	}

	static String getNewPlay(String[] args) {
		for (int i = 0; i < args.length; i++) {
			if (args[i].equals(Application.NEW_PLAY_OPTION)) {
				return args[i + 1];
			}
		}
		return null;
	}

	static boolean existingPlayOption(String[] args) {
		if (args == null) {
			return false;
		}
		for (String str : args) {
			if (str.equals(Application.EXISTING_PLAY_OPTION)) {
				return true;
			}
		}
		return false;
	}

	static String getExistingPlay(String[] args) {
		for (int i = 0; i < args.length; i++) {
			if (args[i].equals(Application.EXISTING_PLAY_OPTION)) {
				return args[i + 1];
			}
		}
		return null;
	}

	public static boolean eclipseOption() {
		if (Application.args == null) {
			return false;
		}
		for (String str : Application.args) {
			if (str.equals(Application.ECLIPSE_OPTION)) {
				return true;
			}
		}
		return false;
	}

	public static boolean OOTOption(String[] args) {
		if (args == null) {
			return false;
		}
		for (String str : args) {
			if (str.equals(Application.OOT_OPTION)) {
				return true;
			}
		}
		return false;
	}

	public static boolean isStandAlone() {
		if (Application.args == null) {
			return false;
		}
		for (String str : Application.args) {
			if (str.equals(Application.STANDALONE_OPTION)) {
				return true;
			}
		}
		return false;
	}

	public static boolean isApplet() {
		if (Application.args == null) {
			return false;
		}
		for (String str : Application.args) {
			if (str.equals(Application.APPLET_OPTION)) {
				return true;
			}
		}
		return false;
	}
}

class PictureThread extends Thread {

	PictureFrame pframe;

	public void run() {
		this.pframe = new PictureFrame();
		this.pframe.setVisible(true);
		try {
			Thread.sleep(1);
		} catch (InterruptedException exc) {
		}
	}
}

class MainThread extends Thread {

	String[] args;

	MainThread(String[] args) {
		this.args = args;
	}

	public void run() {

		Console console = new Console();
		if (!Application.isApplet()) {
			System.setOut(new PrintStream(console.getOut()));
			System.setErr(new PrintStream(console.getErr()));
			System.setIn(console.getIn());
		}

		if (Application.newPlayOption(this.args)) {
			Application.openNewPlay(Application.getNewPlay(this.args));
		} else if (Application.existingPlayOption(this.args)) {

			if (!Application.isStandAlone()) {
				Application.openPlay(new File(Application
						.getExistingPlay(this.args)
						+ File.separatorChar + "theater.xml"));
			} else {
				Application.openStandAlonePlay("data/theater.xml");
			}

		} else {
			Application.openEmptyPlay();
		}

		if (Application.isApplet()) {
			handleApplet();
		}

	}

	void handleApplet() {
		PlayFrame frame = Play.getPlay().getPlayFrame();
		frame.remove(frame.getToolBar());
		frame.remove(frame.getStagePanel());

		StandAloneApplet.applet.setLayout(new BorderLayout());
		StandAloneApplet.applet.add(frame.getToolBar(), BorderLayout.NORTH);
		StandAloneApplet.applet.add(frame.getStagePanel(), BorderLayout.CENTER);

	}
}
