package simulation;

import java.util.ArrayList;
import java.util.List;

import model.Play;
import simulation.listener.EventObject;
import theater.Actor;
import theater.Component;
import theater.Performance;
import theater.Stage;
import theater_intern.IComponent;
import theater_intern.IStage;
import theater_intern.TheaterObservable;
import util.Utils;

public class ActSimulator extends Thread {

	private Object syncObject;
	private boolean stopped;
	ArrayList<EventObject> eventQueue;
	Object eventSyncObject;
	IStage newStage;

	public ActSimulator() {
		this.syncObject = new Object();
		eventQueue = new ArrayList<EventObject>();
		eventSyncObject = new Object();
		this.setPriority(Thread.MAX_PRIORITY);
		this.newStage = null;
	}

	public void stopSimulator() {
		synchronized (this.syncObject) {
			this.stopped = true;
		}
	}

	public void run() {
		Play play = Play.getPlay();
		this.stopped = false;
		while (true) {
			Stage stage = IStage.getStage(play.getActiveStage());
			stage.run();

			List<Actor> actors = play.getActiveStage().getActorsInActOrder();
			for (Actor actor : actors) {
				if (actor.getStage() == stage) {
					actor.run();
				}
			}

			this.executeEventQueue(stage);

			synchronized (this.syncObject) {
				if (this.stopped) {
					return;
				}
			}

			handleStageChange();

			TheaterObservable.getObservable().cycleEnded();

			try {
				double speed = play.getActivePerformance().getSimulationSpeed();
				if (speed <= 0) {
					speed = 0.5;
				}
				int value = (int) ((-Math.log(speed) + Math
						.log(Performance.MAX_SPEED)) * 200);

				Thread.sleep(value);
			} catch (InterruptedException exc) {
				Thread.currentThread().interrupt();
			}

			synchronized (this.syncObject) {
				if (this.stopped) {
					return;
				}
			}

		}
	}

	public void insertEventObject(EventObject obj) {
		synchronized (eventSyncObject) {
			eventQueue.add(obj);
		}
	}

	public void executeEventQueue(Stage stage) {
		synchronized (eventSyncObject) {
			for (EventObject obj : eventQueue) {
				if (obj.getComp() == null || obj.getComp().getStage() == stage) {
					obj.call();
				}
			}
			eventQueue.clear();
		}
	}

	public void setStage(IStage stage) {
		this.newStage = stage;
	}

	private void handleStageChange() {
		IStage currentStage = Play.getPlay().getActiveStage();
		if (newStage != null && newStage != currentStage) {
			Play.getPlay().setActiveStage(newStage);
			newStage = null;
			Play.getPlay().getStagePanel().requestFocusInWindow();
		}
	}
}
