package simulation;

import simulation.listener.EventObject;
import theater_intern.IStage;

public abstract class SimulationManager {

	private static SimulationManager simManager = null;

	public static SimulationManager getSimulationManager() {
		return simManager;
	}
	
	public static void setSimulationManager(SimulationManager man) {
		simManager = man;
	}

	public abstract void handleStart();

	public abstract void handleStop();
	
	public abstract void handleAPIStop();
	
	public abstract void insertEventObject(EventObject obj);
	
	public abstract void setStage(IStage stage);

}
