package theater;

/**
 * Die Klasse Prop ist die Basisklasse aller Requisiten. Sie ist Unterklasse der
 * Klasse Component und erbt alle deren Methoden.
 * <p>
 * </p>
 * Soll eine neue Requisite definiert werden, muss eine entsprechende Klasse von
 * der Klasse Prop abgeleitet werden. Zum Umgang mit den Requisiten knnen die
 * geerbten Methoden der Klassen Component genutzt werden.
 * 
 * @author Dietrich Boles, Universitt Oldenburg, Germany
 * @version 1.0 (08.09.2009)
 * 
 */
public class Prop extends Component {

	/**
	 * Default-Konstruktor der Klasse Prop
	 */
	public Prop() {
		super(false);
	}

	/**
	 * berschreibt die Component-Methode run als leere Methode und definiert
	 * sie als final. Damit wird verhindert, dass die Requisiten als passive
	 * Objekte selbststndig agieren knnen.
	 * 
	 * @see theater.Component#run()
	 */
	public final void run() {
	}

}
