package data;

import theater.*;

import java.util.List;


/**
 * Uebernommen aus dem Greenfoot-Szenario asteroids.
 * <p>
 * </p>
 * A bullet that can hit asteroids.
 *
 */
public class Bullet extends MovingThing {
    /** A bullet looses one life each act, and will disappear when life = 0 */
    private int life = 30;

    /** The damage this bullet will deal */
    private int damage = 16;

    public Bullet() {
        setImage("bullet.png");
    }

    public Bullet(Vector speed, int rotation) {
        super(speed);
        setImage("bullet.png");
        setRotation(rotation);
        increaseSpeed(new Vector(rotation, 15));
        Performance.getPerformance().playSound("EnergyGun.wav");
    }

    /**
     * The bullet will damage asteroids if it hits them.
     */
    public void run() {
        if (life <= 0) {
            getStage().remove(this);
        } else {
            move();

            List<Component> comps = getStage()
                                        .getIntersectingComponents(this,
                    Asteroid.class);

            if (comps.size() > 0) {
                Asteroid asteroid = (Asteroid) comps.get(0);
                getStage().remove(this);
                asteroid.hit(damage);
            }

            life--;
        }
    }
}
