package data;

import theater.*;


/**
 * Uebernommen aus dem Greenfoot-Szenario asteroids.
 * <p>
 * </p>
 * A thing that can move around with a certain speed.
 *
 */
public abstract class MovingThing extends Actor {
    private Vector speed = new Vector();
    private double x = 0;
    private double y = 0;

    public MovingThing() {
    }

    /**
     * Create new thing initialised with given speed.
     */
    public MovingThing(Vector speed) {
        this.speed = speed;
    }

    /**
     * Move forward one step.
     */
    public void move() {
        x = x + speed.getX();
        y = y + speed.getY();

        if (x >= getStage().getNumberOfColumns()) {
            x = 0;
        }

        if (x < 0) {
            x = getStage().getNumberOfColumns() - 1;
        }

        if (y >= getStage().getNumberOfRows()) {
            y = 0;
        }

        if (y < 0) {
            y = getStage().getNumberOfRows() - 1;
        }

        setLocation(x, y);
    }

    public void setLocation(double x, double y) {
        this.x = x;
        this.y = y;
        super.setLocation((int) x, (int) y);
    }

    public void setLocation(int x, int y) {
        setLocation((double) x, (double) y);
    }

    /**
     * Increase the speed with the given vector.
     */
    public void increaseSpeed(Vector s) {
        speed.add(s);
    }

    /**
     * Return the current speed.
     */
    public Vector getSpeed() {
        return speed;
    }
}
