package editor.listener;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import util.ResourceManager;

import editor.Editor;

/**
 * Druckt den Inhalt des Editors aus
 * 
 * @author Dietrich Boles, Uni Oldenburg
 * @version 1.0 (12.11.2008)
 * 
 */
public class IndentListener implements ActionListener {

	Editor editor;

	public IndentListener(Editor editor) {
		this.editor = editor;
	}

	public void actionPerformed(ActionEvent e) {
		this.editor.changeIndent();
		if (this.editor.isIndent()) {
			this.editor.getMessagePanel().writeInfo(
					ResourceManager.getResourceManager().getValue(
							"msg.editor.indent"));
		} else {
			this.editor.getMessagePanel().writeInfo(
					ResourceManager.getResourceManager().getValue(
							"msg.editor.noindent"));
		}
	}

}
