package theater;

import theater_intern.IStage;

import model.Play;

/**
 * Sowohl die Klasse Stage als auch die Klasse Component definieren die von der
 * Java-GUI-Programmierung bekannten Methoden zur Verarbeitung von
 * Tastatur-Events: keyTyped, keyPressed und keyRealeased. Die Events
 * entsprechen dabei den Events des Java-AWT in der Klasse
 * java.awt.event.KeyListener. Den Methoden werden Objekte vom Typ KeyInfo
 * bergeben, ber die genauere Informationen ber das entsprechende Event
 * abgefragt werden knnen.
 * <p>
 * </p>
 * Die Klasse KeyInfo ist von der Klasse java.awt.event.KeyEvent abgeleitet, so
 * dass auch alle deren Methoden benutzt werden knnen.
 * 
 * @author Dietrich Boles, Universitt Oldenburg, Germany
 * @version 1.0 (08.09.2009)
 * 
 */
public class KeyInfo extends java.awt.event.KeyEvent {

	/**
	 * intern verwendetes Objekt
	 */
	private Object userObject;
	
	/**
	 * intern verwendetes Objekt
	 */
	private Stage stage;

	/**
	 * Konstruktor zur Initialisierung eines KeyInfo-Objektes mit einem
	 * KeyEvent-Objekt.
	 * <p>
	 * </p>
	 * Der Konstruktor wird Theater-intern aufgerufen.
	 * 
	 * @param e
	 *            das eingetretene KeyEvent
	 */
	public KeyInfo(java.awt.event.KeyEvent e) {
		super((java.awt.Component) e.getSource(), e.getID(), e.getWhen(), e
				.getModifiers(), e.getKeyCode(), e.getKeyChar(), e
				.getKeyLocation());
		this.userObject = null;
		this.stage = IStage.getStage(Play.getPlay().getActiveStage());
	}

	/**
	 * berschreibt die geerbte Methode und liefert das aktuelle Stage-Objekt.
	 * 
	 * @return das aktuelle Stage-Objekt
	 * 
	 * @see java.util.EventObject#getSource()
	 */
	public Object getSource() {
		return this.stage;
	}

	/**
	 * Tritt ein Tastatur-Event ein, so werden alle Komponenten und die Bhne
	 * darber informiert, insofern sie eine entsprechenden Handler-Methode
	 * definiert und die Tastatur-Event-Benachrichtigung aktiviert haben. Fr
	 * die Reihenfolge der Benachrichtigung gilt: Je weiter das Objekt auf der
	 * Bhne im Vordergrund ist, desto eher wird es informiert. Die Bhne wird
	 * als letzte informiert. Das KeyInfo-Objekt, das dabei den Methoden
	 * bergeben wird, ist dabei immer das gleiche. ber die Methode
	 * setUserObject bekommen die Komponenten die Mglichkeit zu kommunizieren,
	 * indem sie dem KeyInfo-Objekt ein anwendungsspezifisches Objekt
	 * zuzuordnen, das spter benachrichtigte Objekte ber die Methode
	 * getUserObject abfragen knnen.
	 * 
	 * @param userObject
	 *            ein beliebiges anwendungsspezifisches Objekt
	 */
	public void setUserObject(Object userObject) {
		this.userObject = userObject;
	}

	/**
	 * Tritt ein Tastatur-Event ein, so werden alle Komponenten und die Bhne
	 * darber informiert, insofern sie eine entsprechenden Handler-Methode
	 * definiert und die Tastatur-Event-Benachrichtigung aktiviert haben. Fr
	 * die Reihenfolge der Benachrichtigung gilt: Je weiter das Objekt auf der
	 * Bhne im Vordergrund ist, desto eher wird es informiert. Die Bhne wird
	 * als letzte informiert. Das KeyInfo-Objekt, das dabei den Methoden
	 * bergeben wird, ist dabei immer das gleiche. ber die Methode
	 * setUserObject bekommen die Komponenten die Mglichkeit zu kommunizieren,
	 * indem sie dem KeyInfo-Objekt ein anwendungsspezifisches Objekt
	 * zuzuordnen, das spter benachrichtigte Objekte ber die Methode
	 * getUserObject abfragen knnen.
	 * 
	 * @return das dem KeyInfo-Objekt mittels der Methode setUserObject
	 *         zugeordnete Objekt oder null, falls kein Objekt zugeordnet wurde.
	 */
	public Object getUserObject() {
		return this.userObject;
	}

	/**
	 * berschreibt die geerbte Methode und liefert im Falle eines Aufrufs eine
	 * RuntimeException, da ein Zugriff auf die Theater-interne
	 * Java-AWT-Komponente nicht erlaubt ist.
	 * 
	 * @return wirft immer eine RuntimeException
	 * @throws RuntimeException
	 *             wird bei jedem Aufruf der Methode geworfen
	 * 
	 * @see java.awt.event.ComponentEvent#getComponent()
	 */
	public java.awt.Component getComponents() throws RuntimeException {
		throw new RuntimeException("not allowed");
	}

}
