package theater_intern;

import java.util.Observable;

/**
 * ber diese Klasse werden Interessierte, wie das StagePanel ber nderungen
 * des Modells informiert
 * 
 * @author Dietrich Boles, Uni Oldenburg
 * @version 1.0 (12.11.2008)
 * 
 */
public class TheaterObservable extends Observable {

	private static TheaterObservable observable = null;
	
	private boolean enabled = true;

	static {
		observable = new TheaterObservable();
		TheaterObserver.getObserver(); // nur zum Laden der Klasse
	}

	/**
	 * Liefert das aktuelle Theater-Observable
	 * 
	 * @return
	 */
	public static TheaterObservable getObservable() {
		return observable;
	}

	public static void setObservable(TheaterObservable ob) {
		observable = ob;
	}

	/**
	 * Wird bei jeder Zustandnderung aufgerufen
	 */
	public void stateChange() {
		if (!enabled) {
			return;
		}
		
		this.setChanged();
		this.notifyObservers(StateChange.SINGLE_CHANGE);
		this.clearChanged();
		
	}

	/**
	 * Wird nach Abarbeitung eines bestimmten Zyklus (act-Zyklus) aufgerufen
	 */
	public void cycleEnded() {
		if (!enabled) {
			return;
		}
		
		this.setChanged();
		this.notifyObservers(StateChange.CYCLE_END);
		this.clearChanged();
		
	}

	/**
	 * Wichtige Zustandsnderung
	 */
	public void importantStateChange() {
		if (!enabled) {
			return;
		}
		this.setChanged();
		this.notifyObservers(StateChange.IMPORTANT_CHANGE);
		this.clearChanged();
	}
	
	/**
	 *  Zustandsnderung der Performance
	 */
	public void performanceStateChange() {
		if (!enabled) {
			//return;
		}
		this.setChanged();
		this.notifyObservers(StateChange.PERFORMANCE_CHANGE);
		this.clearChanged();
	}
	
	public void setEnabled(boolean en) {
		this.enabled = en;
	}

	protected TheaterObservable() {
	}
}
