package listener;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

import model.Play;
import util.IO;
import util.ResourceManager;
import view.JImageChooser;

/**
 * Listener zum Auswhlen eines Bildes
 * 
 * @author Dietrich Boles, Uni Oldenburg
 * @version 1.0 (12.11.2008)
 * 
 */
public class LoadImageListener implements ActionListener {

	public void actionPerformed(ActionEvent e) {
		LoadImageListener.loadImage();
	}

	/**
	 * Ldt ein oder mehrere Bilder und speichert sie im Theaterstck-Unterverzeichnis "images"
	 * ab
	 */
	public static void loadImage() {
		JImageChooser chooser = JImageChooser.getInstance();
		chooser.setMultiSelectionEnabled(true);
		int returnVal = chooser.showDialog(Play.getPlay().getPlayFrame(),
				ResourceManager.getResourceManager().getValue("import"));
		if (returnVal == JFileChooser.APPROVE_OPTION) {
			File[] fromFiles = chooser.getSelectedFiles();
			boolean success = true;
			for (File fromFile : fromFiles) {
				File dir = new File(Play.getPlay().getDirectory());
				File toFile = new File(dir.getAbsolutePath()
						+ File.separatorChar + "images" + File.separatorChar
						+ fromFile.getName());
				success = success && IO.copyMediaFile(fromFile, toFile);
			}
			if (success) {
				Play.getPlay().getPlayFrame().getMessagePanel().writeInfo(
						ResourceManager.getResourceManager().getValue(
								"msg.filecopysuccessfull"));
			} else {
				JOptionPane.showMessageDialog(Play.getPlay().getPlayFrame(),
						ResourceManager.getResourceManager().getValue(
								"msg.filecopynotsuccessfull"), ResourceManager
								.getResourceManager().getValue("msg.error"),
						JOptionPane.ERROR_MESSAGE);
			}
		}
	}
}
