package simulation;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

import model.Play;
import simulation.listener.EventObject;
import theater_intern.IStage;
import theater_intern.TheaterObservable;
import theater_intern.TheaterObserver;
import util.ResourceManager;
import view.MyButton;

public class ActSimulationManager extends SimulationManager implements
		ActionListener {

	public final static int WAIT_TIME = 5000;

	private JButton startButton, resetButton;
	private JMenuItem startItem, stopItem, resetItem;
	private MyButton stopButton;

	private ActSimulator simulator;

	public ActSimulationManager(JButton startButton, MyButton stopButton,
			JButton resetButton, JMenuItem startItem, JMenuItem stopItem,
			JMenuItem resetItem) {
		this.startButton = startButton;

		this.stopButton = stopButton;
		this.resetButton = resetButton;
		this.startItem = startItem;
		this.stopItem = stopItem;
		this.resetItem = resetItem;
		this.startButton.setEnabled(true);
		this.startItem.setEnabled(true);
		this.stopButton.setEnabled(false);
		this.stopItem.setEnabled(false);
		this.resetButton.setEnabled(true);
		this.resetItem.setEnabled(true);
		this.simulator = null;
		TheaterObserver.setObserver(new ActTheaterObserver());
	}

	public void actionPerformed(ActionEvent e) {
		Play.getPlay().setEventQueueActive(true);
		try {
			JComponent c = (JComponent) e.getSource();
			if (c == this.startButton || c == this.startItem) {
				this.handleStart();
			} else if (c == this.stopButton || c == this.stopItem) {
				EventQueue.invokeLater(new Runnable() {
					public void run() {
						stopButton.setPressed();
						stopButton.getModel().setPressed(true);
						stopButton.getModel().setArmed(true);
					}
				});
				this.stopItem.setEnabled(false);
				new Thread() {
					public void run() {
						handleStop();
					}
				}.start();
			} else if (c == this.resetButton || c == this.resetItem) {
				this.handleReset();
			}
		} finally {
			Play.getPlay().setEventQueueActive(false);
		}
	}

	public void handleStart() {
		Play.getPlay().getActivePerformance().startSimulation();
		this.startButton.setEnabled(false);
		this.startItem.setEnabled(false);
		this.stopButton.setEnabled(true);
		this.stopItem.setEnabled(true);
		this.resetButton.setEnabled(true);
		this.resetItem.setEnabled(true);
		this.simulator = new ActSimulator();
		this.simulator.start();
	}

	public void handleStop() {
		if (this.simulator != null) {
			this.simulator.stopSimulator();
			try {
				this.simulator.join(ActSimulationManager.WAIT_TIME);
				if (simulator == null) { // wenn zwischenzeitlich reset gedrckt
					// wurde
					this.stopButton.reset();
					return;
				}
				if (this.simulator.isAlive()) {
					this.simulator.stop();
					JOptionPane.showMessageDialog(null, ResourceManager
							.getResourceManager().getValue(
									"msg.simulationstopped"), ResourceManager
							.getResourceManager().getValue("msg.error"),
							JOptionPane.ERROR_MESSAGE);
					Play.getPlay().getActivePerformance().setStopped();
					TheaterObservable.getObservable().performanceStateChange();
					Play.getPlay().reset();
					this.startButton.setEnabled(true);
					this.startItem.setEnabled(true);
					this.stopButton.setEnabled(false);
					this.stopItem.setEnabled(false);
					this.resetButton.setEnabled(true);
					this.resetItem.setEnabled(true);
					this.stopButton.reset();
					this.simulator = null;
					return;
				}
			} catch (InterruptedException exc) {
			}
			this.simulator = null;
		}
		TheaterObservable.getObservable().cycleEnded();
		Play.getPlay().getActivePerformance().setStopped();
		this.startButton.setEnabled(true);
		this.startItem.setEnabled(true);
		this.stopButton.setEnabled(false);
		this.stopItem.setEnabled(false);
		this.resetButton.setEnabled(true);
		this.resetItem.setEnabled(true);
		this.stopButton.reset();
	}

	public void handleAPIStop() {
		if (this.simulator != null) {
			this.simulator.stopSimulator();
			this.simulator = null;
		}
		TheaterObservable.getObservable().cycleEnded();
		this.startButton.setEnabled(true);
		this.startItem.setEnabled(true);
		this.stopButton.setEnabled(false);
		this.stopItem.setEnabled(false);
		this.resetButton.setEnabled(true);
		this.resetItem.setEnabled(true);
	}

	public void handleReset() {
		if (this.simulator != null) {
			this.simulator.stop();
			this.simulator = null;
		}
		Play.getPlay().getActivePerformance().setStopped();
		this.startButton.setEnabled(true);
		this.startItem.setEnabled(true);
		this.stopButton.setEnabled(false);
		this.stopItem.setEnabled(false);
		this.resetButton.setEnabled(true);
		this.resetItem.setEnabled(true);
		Play.getPlay().reset();
	}

	public void insertEventObject(EventObject obj) {
		if (this.simulator != null) {
			this.simulator.insertEventObject(obj);
		}
	}
	
	public void setStage(IStage stage) {
		if (this.simulator != null) {
			this.simulator.setStage(stage);
		}
	}

}
