package simulation.listener;

import java.awt.event.InputEvent;

import theater.Component;
import theater.Stage;

public abstract class EventObject {

	protected Component comp;
	protected Stage stage;
	protected InputEvent eventInfo;

	public EventObject(Component comp, InputEvent info) {
		this.comp = comp;
		this.eventInfo = info;
		this.stage = null;
	}
	
	public EventObject(Stage stage, InputEvent info) {
		this.stage = stage;
		this.eventInfo = info;
		this.comp = null;
	}

	public abstract void call();

	public Component getComp() {
		return comp;
	}

	public Stage getStage() {
		return stage;
	}
}
