package util;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Locale;
import java.util.Properties;

/**
 * Verwaltung der Properties; aktuell language und jdk.
 * 
 * @author Dietrich Boles, Uni Oldenburg
 * @version 1.0 (12.11.2008)
 * 
 */
public class PropertyManager {

	private static String DEF_LANGUAGE = "de";
	private static String PROP_FILE = "theater.properties";

	private static PropertyManager manager = null;
	private Properties props;

	/**
	 * erzeugt einen Property-Manager. Geladen werden die Properties aus der
	 * Datei "theater.properties"
	 */
	protected PropertyManager() {
		this.props = new Properties();
		try {
			this.props = new Properties();
			FileInputStream propInFile = new FileInputStream(
					PropertyManager.PROP_FILE);
			this.props.load(propInFile);
			propInFile.close();
		} catch (Throwable exc) {
			//exc.printStackTrace();
		}
	}

	/**
	 * Liefert den PropertyManager
	 * 
	 * @return
	 */
	public static PropertyManager getPropertyManager() {
		if (PropertyManager.manager == null) {
			PropertyManager.manager = new PropertyManager();
		}
		return PropertyManager.manager;
	}

	/**
	 * Liefert die eingestellte Sprache (deutsch oder englisch)
	 * 
	 * @return
	 */
	public String getLanguage() {
		String lang = this.props.getProperty("language");
		return lang != null ? lang : PropertyManager.DEF_LANGUAGE;
	}

	/**
	 * Liefert die Locale in Abhngigkeit der eingestellten Sprache
	 * 
	 * @return
	 */
	public Locale getLocale() {
		String language = this.getLanguage();
		if (language.equals("en")) {
			return Locale.ENGLISH;
		} else if (language.equals("de")) {
			return Locale.GERMAN;
		}
		return Locale.getDefault();
	}

	/**
	 * Speichert die Property jdk. Hierin wird gespeichert, welches JDK benutzt
	 * werden soll.
	 * 
	 * @param jdk
	 */
	public void setJDK(String jdk) {
		this.props.setProperty("jdk", jdk);
		try {
			FileOutputStream prop = new FileOutputStream(
					PropertyManager.PROP_FILE);
			this.props.store(prop, "");
			prop.close();
		} catch (Throwable th) {
			th.printStackTrace();
		}
	}

	/**
	 * Liefert die Property jdk. Hierin ist gespeichert, welches JDK benutzt
	 * werden soll. Es kann auch null geliefert werden, wenn die Property noch
	 * nicht gesetzt wurde.
	 * 
	 * @return
	 */
	public String getJDK() {
		return this.props.getProperty("jdk");
	}

}
