package view;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;

import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

import listener.Application;
import model.Play;
import util.IO;
import util.ResourceManager;
import util.ZipArchives;

import compiler.CompileManager;

public class GenerateDialog extends JDialog {

	private static GenerateDialog instance = null;

	JLabel nameLabel;
	JLabel splashLabel;
	JLabel dirLabel;

	JTextField nameField;
	JTextField splashField;
	JTextField dirField;

	JButton splashButton;
	JButton dirButton;

	public static GenerateDialog getInstance() {
		if (instance == null) {
			instance = new GenerateDialog();
		}
		return instance;
	}

	private GenerateDialog() {
		super(Play.getPlay().getPlayFrame(), ResourceManager
				.getResourceManager().getValue("generate.dialog.title"), true);
		this.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
		this.setLayout(new BorderLayout(10, 10));

		JPanel mainPanel = new JPanel();
		mainPanel.setLayout(new GridLayout(0, 3, 5, 5));

		mainPanel.add(new JPanel()); // dummy
		mainPanel.add(new JPanel()); // dummy
		mainPanel.add(new JPanel()); // dummy

		// this.nameLabel = new JLabel(ResourceManager.getResourceManager()
		// .getValue("generate.dialog.name"), JLabel.RIGHT);
		// this.nameLabel.setToolTipText(ResourceManager.getResourceManager()
		// .getValue("generate.dialog.namedesc"));
		// mainPanel.add(this.nameLabel);
		// String genName = "Auffhrung";
		// this.nameField = new JTextField(genName, 12);
		// this.nameField.setToolTipText(ResourceManager.getResourceManager()
		// .getValue("generate.dialog.namedesc"));
		// mainPanel.add(this.nameField);
		// mainPanel.add(new JPanel()); // dummy

		this.dirLabel = new JLabel(ResourceManager.getResourceManager()
				.getValue("generate.dialog.dir"), JLabel.RIGHT);
		this.dirLabel.setToolTipText(ResourceManager.getResourceManager()
				.getValue("generate.dialog.dirdesc"));
		mainPanel.add(this.dirLabel);
		this.dirField = new JTextField(12);
		this.dirField.setToolTipText(ResourceManager.getResourceManager()
				.getValue("generate.dialog.dirdesc"));
		mainPanel.add(this.dirField);
		this.dirButton = new JButton(ResourceManager.getResourceManager()
				.getValue("generate.dialog.dirbutton"));
		this.dirButton.setToolTipText(ResourceManager.getResourceManager()
				.getValue("generate.dialog.dirdesc"));
		this.dirButton.addActionListener(new DirChooser(this.dirField));
		mainPanel.add(dirButton);

		mainPanel.add(new JPanel()); // dummy
		mainPanel.add(new JPanel()); // dummy
		mainPanel.add(new JPanel()); // dummy

		this.splashLabel = new JLabel(ResourceManager.getResourceManager()
				.getValue("generate.dialog.splash"), JLabel.RIGHT);
		this.splashLabel.setToolTipText(ResourceManager.getResourceManager()
				.getValue("generate.dialog.splashdesc"));
		mainPanel.add(this.splashLabel);
		this.splashField = new JTextField(12);
		this.splashField.setToolTipText(ResourceManager.getResourceManager()
				.getValue("generate.dialog.splashdesc"));
		mainPanel.add(this.splashField);
		this.splashButton = new JButton(ResourceManager.getResourceManager()
				.getValue("generate.dialog.splashbutton"));
		this.splashButton.setToolTipText(ResourceManager.getResourceManager()
				.getValue("generate.dialog.splashdesc"));
		this.splashButton.addActionListener(new ImageChooser(this.splashField));
		mainPanel.add(splashButton);

		mainPanel.add(new JPanel()); // dummy
		mainPanel.add(new JPanel()); // dummy
		mainPanel.add(new JPanel()); // dummy

		this.add(mainPanel, BorderLayout.CENTER);

		JPanel buttonPanel = new JPanel();
		buttonPanel.setLayout(new FlowLayout(FlowLayout.CENTER));
		JButton ok = new JButton(ResourceManager.getResourceManager().getValue(
				"generate.dialog.ok"));
		ok.addActionListener(new OKGenAction(this));
		buttonPanel.add(ok);
		JButton cancel = new JButton(ResourceManager.getResourceManager()
				.getValue("generate.dialog.cancel"));
		cancel.addActionListener(new CancelGenAction(this));
		buttonPanel.add(cancel);
		this.add(buttonPanel, BorderLayout.SOUTH);

		this.pack();
		setLocationRelativeTo(Play.getPlay().getPlayFrame());
		this.setResizable(false);
	}

}

class OKGenAction implements ActionListener {

	GenerateDialog dialog;

	OKGenAction(GenerateDialog d) {
		this.dialog = d;
	}

	public void actionPerformed(ActionEvent e) {
		// Ueberpruefen
		String dir = dialog.dirField.getText();
		if (dir == null || dir.trim().equals("")) {
			JOptionPane.showMessageDialog(Play.getPlay().getPlayFrame(),
					ResourceManager.getResourceManager().getValue(
							"msg.invaliddirname"), ResourceManager
							.getResourceManager().getValue("msg.error"),
					JOptionPane.ERROR_MESSAGE);
			return;
		}
		File dirF = new File(dir.trim());
		if (dirF.exists() && dirF.isFile()) {
			JOptionPane.showMessageDialog(Play.getPlay().getPlayFrame(),
					ResourceManager.getResourceManager().getValue(
							"msg.invaliddirname"), ResourceManager
							.getResourceManager().getValue("msg.error"),
					JOptionPane.ERROR_MESSAGE);
			return;
		}

		// handle name
		Play play = Play.getPlay();

		// Abspeichern, damit korrekt kopiert wird.
		play.save();

		// handle directory and jar-file generation
		File jarFile = null;
		try {
			if (!dirF.exists()) {
				dirF.mkdirs();
			}
			jarFile = new File(dirF, Application.STANDALONE_JAR_NAME);
			IO.copyResMediaFile(Application.STANDALONE_JAR_NAME, jarFile);
		} catch (Throwable th) {
			th.printStackTrace();
			JOptionPane.showMessageDialog(Play.getPlay().getPlayFrame(),
					ResourceManager.getResourceManager().getValue(
							"generate.dialog.errormsg")
							+ "\n" + th, ResourceManager.getResourceManager()
							.getValue("msg.error"), JOptionPane.ERROR_MESSAGE);
			return;
		}

		try {
			// Verzeichnis data erzeugen und die plays-Daten hineinkopieren
			File dataDir = new File("data");
			dataDir.mkdir();
			IO.copyDir(new File(play.getDirectory()), dataDir);

			// in alle java-Dateien package-Statement einfuegen
			String statement = "package data;\n\n";
			File[] files = dataDir.listFiles();
			for (File file : files) {
				if (file.getName().endsWith(".java")) {
					IO.prependStatement(file.getPath(), statement);
				}
			}

			// compilieren
			if (!CompileManager.compileDataDir()) {
				JOptionPane
						.showMessageDialog(
								Play.getPlay().getPlayFrame(),
								ResourceManager.getResourceManager().getValue(
										"generate.dialog.errormsg")
										+ "\n"
										+ ResourceManager
												.getResourceManager()
												.getValue(
														"generate.dialog.errormsg.compile"),
								ResourceManager.getResourceManager().getValue(
										"msg.error"), JOptionPane.ERROR_MESSAGE);
				return;
			}

			// jar-Datei erzeugen
			// ZipArchives.jarDirs(jarFile.getPath(), "1.0",
			// "listener.StandAloneApplication", "data",
			// "compiler", "console", "editor", "listener", "model",
			// "resources", "simulation", "theater", "theater_intern",
			// "util", "view");

			// data-Verzeichnis in jar-Datei einfuegen
			ZipArchives.addFilesToZip("data", jarFile);

			// data-Verzeichnis loeschen
			IO.removeDir(dataDir);
		} catch (Throwable th) {
			th.printStackTrace();
			JOptionPane.showMessageDialog(Play.getPlay().getPlayFrame(),
					ResourceManager.getResourceManager().getValue(
							"generate.dialog.errormsg")
							+ "\n" + th, ResourceManager.getResourceManager()
							.getValue("msg.error"), JOptionPane.ERROR_MESSAGE);
			return;
		}

		// handle splash screen
		try {
			String splashName = dialog.splashField.getText();
			if (splashName != null && !splashName.trim().equals("")) {

				File source = new File(splashName);
				File dest = new File("sim-splashscreen.png");
				BufferedImage bi = ImageIO.read(source);
				ImageIO.write(bi, "png", dest);
				ZipArchives.addFilesToZip(dest.getPath(), jarFile);
				dest.delete();
			}
		} catch (Throwable th) {
			th.printStackTrace();
			JOptionPane.showMessageDialog(Play.getPlay().getPlayFrame(),
					ResourceManager.getResourceManager().getValue(
							"generate.dialog.errormsg")
							+ "\n" + th, ResourceManager.getResourceManager()
							.getValue("msg.error"), JOptionPane.ERROR_MESSAGE);
			return;
		}

		// html generation
		genHTMLCode(dirF);

		this.dialog.dispose();
		Play.getPlay().getPlayFrame().getMessagePanel().writeInfo(
				ResourceManager.getResourceManager().getValue(
						"msg.simgenerated"));
	}

	void genHTMLCode(File dirF) {
		File htmlFile = null;
		try {
			if (!dirF.exists()) {
				dirF.mkdirs();
			}
			htmlFile = new File(dirF, "performance.html");
			PrintWriter out = new PrintWriter(new BufferedWriter(
					new FileWriter(htmlFile)));
			out.println("<html>");
			out.println("<body>");
			int w = Play.getPlay().getPlayFrame().getWidth();
			int h = Play.getPlay().getPlayFrame().getHeight();
			out
					.println("<applet archive=\"performance.jar\" code=\"listener.StandAloneApplet.class\"  "
							+ "width=\"" + w + "\" height=\"" + h + "\">");
			out.println("es sind Fehler aufgetreten");
			out.println("</applet>");
			out.println("</body>");
			out.println("</html>");
			out.close();
		} catch (Throwable th) {
			th.printStackTrace();
		}

	}
}

class CancelGenAction implements ActionListener {

	JDialog dialog;

	CancelGenAction(JDialog d) {
		this.dialog = d;
	}

	public void actionPerformed(ActionEvent e) {
		this.dialog.dispose();
		Play.getPlay().getPlayFrame().getMessagePanel().writeInfo(
				ResourceManager.getResourceManager().getValue(
						"msg.actioncanceled"));
	}

}

class DirChooser implements ActionListener {

	JTextField field;

	DirChooser(JTextField field) {
		this.field = field;
	}

	public void actionPerformed(ActionEvent e) {
		JFileChooser chooser = new JFileChooser();
		chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
		int returnVal = chooser.showDialog(Play.getPlay().getPlayFrame(),
				ResourceManager.getResourceManager().getValue("choose"));
		if (returnVal == JFileChooser.APPROVE_OPTION) {
			field.setText(chooser.getSelectedFile().getAbsolutePath());
		}

	}
}

class ZipChooser implements ActionListener {

	JTextField field;

	ZipChooser(JTextField field) {
		this.field = field;
	}

	public void actionPerformed(ActionEvent e) {
		JFileChooser chooser = new JFileChooser();
		FileFilter filter = new ZipPdfFilter();
		chooser.setFileFilter(filter);
		int returnVal = chooser.showDialog(Play.getPlay().getPlayFrame(),
				ResourceManager.getResourceManager().getValue("choose"));
		if (returnVal == JFileChooser.APPROVE_OPTION) {
			field.setText(chooser.getSelectedFile().getAbsolutePath());
		}

	}
}

class ImageChooser implements ActionListener {

	JTextField field;

	ImageChooser(JTextField field) {
		this.field = field;
	}

	public void actionPerformed(ActionEvent e) {
		JImageChooser chooser = JImageChooser.getInstance();
		chooser.setMultiSelectionEnabled(false);
		chooser.setSelectedFile(null);
		int returnVal = chooser.showDialog(Play.getPlay().getPlayFrame(),
				ResourceManager.getResourceManager().getValue("choose"));
		if (returnVal == JFileChooser.APPROVE_OPTION) {
			String str = chooser.getSelectedFile().getAbsolutePath();
			field.setText(str);
		}
	}
}

class ZipPdfFilter extends FileFilter {

	public boolean accept(File f) {
		if (f.isDirectory()) {
			return true;
		}
		return f.getName().toLowerCase().endsWith(".zip")
				|| f.getName().toLowerCase().endsWith(".pdf");
	}

	public String getDescription() {
		return "zip, pdf";
	}

}
