package data;

import theater.*;

import java.awt.Color;
import java.awt.Font;


public class ChoiceButton extends Prop {
    String text;

    public ChoiceButton(String text) {
        this.text = text;
        createAndSetImage();
    }

    private void createAndSetImage() {
        TheaterImage image = new TheaterImage(170, 80);
        image.setColor(new Color(200, 200, 200, 50));
        image.fillRect(0, 0, 150, 60);
        image.setColor(Color.ORANGE);

        Font font = image.getFont();
        image.setFont(font.deriveFont(24.0f));
        image.drawRect(0, 0, 150, 60);
        image.drawString(text, 75 - (text.length() * 7), 40);
        setImage(image);
    }

    public void mousePressed(MouseInfo event) {
        ((CurvesWorld) getStage()).finishChoice(this);
    }
}
