package data;

import theater.KeyInfo;


public class Curve extends Fragment {
    private final static int ROTATION_DEGREE = 20;
    private final static int SPEED = 5;
    static Clock clock;
    private boolean dead;
    private Player player;
    private int size;
    private int startSize;
    private boolean plusPressed;
    private boolean minusPressed;

    public Curve(Player player) {
        super(player.getColor());
        this.player = player;
        this.dead = false;
        this.startSize = new java.util.Random().nextInt(3) + 3;
        this.size = this.startSize;
        this.plusPressed = false;
        this.minusPressed = false;
    }

    public void run() {
        if (this.dead) {
            return;
        }

        if ((clock != null) && !clock.isNull()) {
            return;
        }

        clock = null;
        handleKeys();
        ahead();
    }

    void stop() {
        dead = true;
    }

    private void handleKeys() {
        if (minusPressed) {
            setRotation(getRotation() - ROTATION_DEGREE);
        }

        if (plusPressed) {
            setRotation(getRotation() + ROTATION_DEGREE);
        }
    }

    private void ahead() {
        double angle = Math.toRadians(getRotation());
        int oldX = getColumn();
        int oldY = getRow();
        int newX = (int) Math.round(getColumn() + (Math.cos(angle) * SPEED));
        int newY = (int) Math.round(getRow() + (Math.sin(angle) * SPEED));

        // check border
        if ((newX < 0) ||
                (newX >= (getStage().getNumberOfColumns() -
                CurvesWorld.BORDERWIDTH)) || (newY < 0) ||
                (newY >= getStage().getNumberOfRows())) {
            stop();
            ((CurvesWorld) this.getStage()).dead(this.player);

            return;
        }

        // check collision
        getStage().getIntersectingComponents(this, Fragment.class);

        if (getStage().getIntersectingComponents(this, Fragment.class).size() > 1) {
            dead = true;
            ((CurvesWorld) this.getStage()).dead(this.player);

            return;
        }

        // ok: extending the curve
        size++;

        if (size > startSize) {
            Fragment fragment = new Fragment(this.getColor());
            this.getStage().add(fragment, oldX, oldY);

            if (size == 50) {
                this.startSize = new java.util.Random().nextInt(5) + 1;
                size = 0;
            }
        }

        this.setLocation(newX, newY);
    }

    static void startClock() {
        clock = new Clock(2000);
    }

    public void keyPressed(KeyInfo event) {
        if (event.getKeyCode() == player.getMinusKey()) {
            minusPressed = true;
        }

        if (event.getKeyCode() == player.getPlusKey()) {
            plusPressed = true;
        }
    }

    public void keyReleased(KeyInfo event) {
        if (event.getKeyCode() == player.getMinusKey()) {
            minusPressed = false;
        }

        if (event.getKeyCode() == player.getPlusKey()) {
            plusPressed = false;
        }
    }
}
