package editor;

import java.awt.Color;

import javax.swing.JTextPane;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.StyleConstants;

/**
 * Ein TextPane, in dem die Zeilennummern des Editors angezeigt werden.
 * 
 * @author Dietrich Boles, Uni Oldenburg
 * @version 1.0 (12.11.2008)
 * 
 */
public class LineNumberPanel extends JTextPane {

	LineNumberDocument doc;

	public LineNumberPanel(Editor editor) {
		this.doc = new LineNumberDocument(editor);
		this.setDocument(this.doc);
		this.setBackground(new Color(230, 230, 230));
	}

	public void setNumberOfLines(int noOfLines) {

		StringBuffer text = new StringBuffer();
		for (int i = 1; i <= noOfLines; i++) {
			text.append(i + "\n");
		}
		this.setText(text.toString());
	}

}

class LineNumberDocument extends DefaultStyledDocument {
	Editor editor;

	public LineNumberDocument(Editor editor) {
		this.editor = editor;
		initStyles();
	}

	protected void initStyles() {
		this.addStyle("plain", this.getStyle("default"));
		StyleConstants.setFontFamily(this.getStyle("plain"), "Monospaced");
		StyleConstants
				.setFontSize(this.getStyle("plain"), editor.getFontSize());
		this.setParagraphAttributes(0, this.getLength(),
				this.getStyle("plain"), true);
		this.setCharacterAttributes(0, this.getLength(),
				this.getStyle("plain"), true);
	}

	public void changeFontSize(int size) {
		this.removeStyle("plain");
		initStyles();
	}

}
