package editor.listener;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.MessageFormat;

import util.ResourceManager;

import editor.Editor;

/**
 * Druckt den Inhalt des Editors aus
 * 
 * @author Dietrich Boles, Uni Oldenburg
 * @version 1.0 (12.11.2008)
 * 
 */
public class PrintListener implements ActionListener {

	Editor editor;

	public PrintListener(Editor editor) {
		this.editor = editor;
	}

	public void actionPerformed(ActionEvent e) {
		try {
			MessageFormat header = null;
			String fileName = this.editor.getFileName();
			if (fileName != null) {
				String playName = fileName.substring(0, fileName
						.indexOf(File.separator));
				String fName = fileName.substring(fileName
						.lastIndexOf(File.separator) + 1, fileName.length());

				header = new MessageFormat(playName + ": " + fName);
			} else {
				header = new MessageFormat("Info");
			}
			MessageFormat footer = new MessageFormat(
					"Programming Theater (www.programming-theater.de)");
			this.editor.getEditorPanel().print(header, footer);
			this.editor.getMessagePanel().writeInfo(
					ResourceManager.getResourceManager().getValue(
							"msg.editor.print"));
		} catch (Throwable e1) {
			e1.printStackTrace();
		}
	}

}
