package simulation;

import java.util.Observable;

import listener.StoppedMouseListener;
import model.Play;
import simulation.listener.SimulationMouseListener;
import simulation.listener.TheaterKeyListener;
import theater_intern.IPerformance;
import theater_intern.StateChange;
import theater_intern.TheaterObserver;
import view.StagePanel;

/**
 * ber diese Klasse werden Interessierte, wie das StagePanel ber nderungen
 * des Modells informiert
 * 
 * @author Dietrich Boles, Uni Oldenburg
 * @version 1.0 (12.11.2008)
 * 
 */
public class ActTheaterObserver extends TheaterObserver {

	public ActTheaterObserver() {
		super();
	}

	public void update(Observable o, Object arg) {
		IPerformance iPerf = Play.getPlay().getActivePerformance();
		StagePanel panel = Play.getPlay().getStagePanel();
		if (panel == null) {
			return;
		}
		if (arg == StateChange.IMPORTANT_CHANGE) {
			panel.repaintStage();
			Play.getPlay().getPlayFrame().getFileTree().repaint();
		} else if (arg == StateChange.SINGLE_CHANGE
				&& (iPerf.simulationStopped())) {
			panel.repaintStage();
		} else if (arg == StateChange.CYCLE_END) {
			panel.repaintStage();
		} else if (arg == StateChange.PERFORMANCE_CHANGE) {
			if (iPerf.simulationRunning()) {
				panel.setMouseListener(new SimulationMouseListener());
				panel.setKeyListener(new TheaterKeyListener());
				panel.requestFocusInWindow();
			} else if (iPerf.simulationStopped()) {
				panel.setMouseListener(new StoppedMouseListener());
				panel.setKeyListener(null);
			}
		}

	}
}
