package simulation.listener;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.List;

import model.Play;
import simulation.SimulationManager;
import theater.Component;
import theater.KeyInfo;
import theater.Stage;
import theater_intern.IComponent;
import theater_intern.IStage;

public class TheaterKeyListener implements KeyListener {

	public TheaterKeyListener() {
		super();
	}

	public void keyPressed(KeyEvent e) {
		SimulationManager simManager = SimulationManager.getSimulationManager();
		KeyInfo keyInfo = new KeyInfo(e);

		IStage iStage = Play.getPlay().getActiveStage();
		List<IComponent> iComps = iStage.getComponentsInPaintOrder();
		for (int i = iComps.size() - 1; i >= 0; i--) {
			IComponent iComp = iComps.get(i);
			Component comp = IComponent.getComp(iComp);
			simManager.insertEventObject(new KeyPressedObject(comp, keyInfo));
		}
		Stage stage = IStage.getStage(iStage);
		simManager.insertEventObject(new KeyPressedObject(stage, keyInfo));
	}

	public void keyReleased(KeyEvent e) {
		SimulationManager simManager = SimulationManager.getSimulationManager();
		KeyInfo keyInfo = new KeyInfo(e);

		IStage iStage = Play.getPlay().getActiveStage();
		List<IComponent> iComps = iStage.getComponentsInPaintOrder();
		for (int i = iComps.size() - 1; i >= 0; i--) {
			IComponent iComp = iComps.get(i);
			Component comp = IComponent.getComp(iComp);
			simManager.insertEventObject(new KeyReleasedObject(comp, keyInfo));
		}

		Stage stage = IStage.getStage(iStage);
		simManager.insertEventObject(new KeyReleasedObject(stage, keyInfo));
	}

	public void keyTyped(KeyEvent e) {
		SimulationManager simManager = SimulationManager.getSimulationManager();
		KeyInfo keyInfo = new KeyInfo(e);

		IStage iStage = Play.getPlay().getActiveStage();
		List<IComponent> iComps = iStage.getComponentsInPaintOrder();
		for (int i = iComps.size() - 1; i >= 0; i--) {
			IComponent iComp = iComps.get(i);
			Component comp = IComponent.getComp(iComp);
			simManager.insertEventObject(new KeyTypedObject(comp, keyInfo));

		}
		Stage stage = IStage.getStage(iStage);
		simManager.insertEventObject(new KeyTypedObject(stage, keyInfo));
	}
}

