package theater;

/**
 * Sowohl die Klasse Stage als auch die Klasse Component definieren die von der
 * Java-GUI-Programmierung bekannten Methoden zur Verarbeitung von Maus-Events:
 * mousePressed, mouseReleased, mouseClicked, mouseDragged, mouseMoved,
 * mouseEntered und mouseExited. Die Events entsprechen dabei den Events des
 * Java-AWT in den Klassen java.awt.event.MouseListener bzw.
 * java.awt.event.MouseMotionListener. Den Methoden werden Objekte vom Typ
 * MouseInfo bergeben, ber die genauere Informationen ber das entsprechende
 * Event abgefragt werden knnen.
 * <p>
 * </p>
 * Die Klasse MouseInfo ist von der Klasse java.awt.event.MouseEvent abgeleitet,
 * so dass auch alle deren Methoden benutzt werden knnen.
 * 
 * @author Dietrich Boles, Universitt Oldenburg, Germany
 * @version 1.0 (08.09.2009)
 * 
 */
public class MouseInfo extends java.awt.event.MouseEvent {

	private int x;
	private int y;
	private int column;
	private int row;
	private Object source;
	private Object userObject;

	/**
	 * Konstruktor zur Initialisierung eines MouseInfo-Objektes mit einem
	 * MouseEvent-Objekt.
	 * <p>
	 * </p>
	 * Der Konstruktor wird Theater-intern aufgerufen.
	 * 
	 * @param e
	 *            das eingetretene MouseEvent
	 */
	public MouseInfo(java.awt.event.MouseEvent e) {
		super((java.awt.Component) e.getSource(), e.getID(), e.getWhen(), e
				.getModifiers(), e.getX(), e.getY(), e.getClickCount(), e
				.isPopupTrigger(), e.getButton());
		this.x = -1;
		this.y = -1;
		this.column = -1;
		this.row = -1;
		this.source = null;
		this.userObject = null;
	}

	/**
	 * berschreibt die geerbte Methode und liefert das jeweilige Komponenten-
	 * bzw. Bhnenobjekt, oberhalb dessen Ikon das Event aufgetreten ist.
	 * 
	 * @return das jeweilige Komponenten- bzw. Bhnenobjekt, oberhalb dessen
	 *         Ikon das Event aufgetreten ist
	 * 
	 * @see java.util.EventObject#getSource()
	 */
	public Object getSource() {
		return this.source;
	}

	/**
	 * berschreibt die geerbte Methode. In dem Fall, dass die Bhne ber das
	 * Maus-Event informiert wird, also das aktuelle Bhnenobjekt das
	 * Source-Objekt ist, liefert die Methode die x-Koordinate des Mauszeigers
	 * bezglich des Hintergrundes. In dem Fall, dass eine Komponente ber das
	 * Maus-Event informiert wird, also die Komponente das Source-Objekt ist,
	 * liefert die Methode die x-Koordinate des Mauszeigers bezglich des der
	 * Komponente zugeordneten Ikons.
	 * 
	 * @return die x-Koordinate des Maus-Events relativ gesehen zum
	 *         Source-Objekt
	 * 
	 * @see java.awt.event.MouseEvent#getX()
	 */
	public int getX() {
		return this.x;
	}

	/**
	 * berschreibt die geerbte Methode. In dem Fall, dass die Bhne ber das
	 * Maus-Event informiert wird, also das aktuelle Bhnenobjekt das
	 * Source-Objekt ist, liefert die Methode die y-Koordinate des Mauszeigers
	 * bezglich des Hintergrundes. In dem Fall, dass eine Komponente ber das
	 * Maus-Event informiert wird, also die Komponente das Source-Objekt ist,
	 * liefert die Methode die y-Koordinate des Mauszeigers bezglich des der
	 * Komponente zugeordneten Ikons.
	 * 
	 * @return die y-Koordinate des Maus-Events relativ gesehen zum
	 *         Source-Objekt
	 * 
	 * @see java.awt.event.MouseEvent#getY()
	 */
	public int getY() {
		return this.y;
	}

	/**
	 * berschreibt die geerbte Methode. In dem Fall, dass die Bhne ber das
	 * Maus-Event informiert wird, also das aktuelle Bhnenobjekt das
	 * Source-Objekt ist, liefert die Methode die x- und y-Koordinate des
	 * Mauszeigers bezglich des Hintergrundes. In dem Fall, dass eine
	 * Komponente ber das Maus-Event informiert wird, also die Komponente das
	 * Source-Objekt ist, liefert die Methode die x- und y-Koordinate des
	 * Mauszeigers bezglich des der Komponente zugeordneten Ikons.
	 * 
	 * @return die x- und y-Koordinate des Maus-Events relativ gesehen zum
	 *         Source-Objekt
	 * @see java.awt.event.MouseEvent#getPoint()
	 */
	public java.awt.Point getPoint() {
		return new java.awt.Point(this.x, this.y);
	}

	/**
	 * Die Methode liefert die Spalte, ber der sich der Mauszeiger aktuell
	 * befindet.
	 * 
	 * @return die Spalte, ber der sich der Mauszeiger befindet
	 */
	public int getColumn() {
		return this.column;
	}

	/**
	 * Die Methode liefert die Reihe, ber der sich der Mauszeiger aktuell
	 * befindet.
	 * 
	 * @return die Reihe, ber der sich der Mauszeiger befindet
	 */
	public int getRow() {
		return this.row;
	}

	/**
	 * Tritt ein Maus-Event ein, so werden alle Komponenten und die Bhne
	 * darber informiert, insofern das Maus-Event oberhalb des ihnen
	 * zugeordneten Icons erfolgte, sie eine entsprechenden Handler-Methode
	 * definiert und die Maus-Event-Benachrichtigung aktiviert haben. Fr die
	 * Reihenfolge der Benachrichtigung gilt: Je weiter das Objekt auf der Bhne
	 * im Vordergrund ist, desto eher wird es informiert. Die Bhne wird als
	 * letzte informiert. Das MouseInfo-Objekt, das dabei den Methoden bergeben
	 * wird, ist dabei immer das gleiche. ber die Methode setUserObject
	 * bekommen die Komponenten die Mglichkeit zu kommunizieren, indem sie dem
	 * MouseInfo-Objekt ein anwendungsspezifisches Objekt zuzuordnen, das spter
	 * benachrichtigte Objekte ber die Methode getUserObject abfragen knnen.
	 * 
	 * @param userObject
	 *            ein beliebiges anwendungsspezifisches Objekt
	 */
	public void setUserObject(Object userObject) {
		this.userObject = userObject;
	}

	/**
	 * Tritt ein Maus-Event ein, so werden alle Komponenten und die Bhne
	 * darber informiert, insofern das Maus-Event oberhalb des ihnen
	 * zugeordneten Icons erfolgte, sie eine entsprechenden Handler-Methode
	 * definiert und die Maus-Event-Benachrichtigung aktiviert haben. Fr die
	 * Reihenfolge der Benachrichtigung gilt: Je weiter das Objekt auf der Bhne
	 * im Vordergrund ist, desto eher wird es informiert. Die Bhne wird als
	 * letzte informiert. Das MouseInfo-Objekt, das dabei den Methoden bergeben
	 * wird, ist dabei immer das gleiche. ber die Methode setUserObject
	 * bekommen die Komponenten die Mglichkeit zu kommunizieren, indem sie dem
	 * MouseInfo-Objekt ein anwendungsspezifisches Objekt zuzuordnen, das spter
	 * benachrichtigte Objekte ber die Methode getUserObject abfragen knnen.
	 * 
	 * @return das dem MouseInfo-Objekt mittels der Methode setUserObject
	 *         zugeordnete Objekt oder null, falls kein Objekt zugeordnet wurde.
	 */
	public Object getUserObject() {
		return this.userObject;
	}

	/**
	 * berschreibt die geerbte Methode und liefert im Falle eines Aufrufs eine
	 * RuntimeException, da ein Zugriff auf die Theater-interne
	 * Java-AWT-Komponente nicht erlaubt ist.
	 * 
	 * @return wirft immer eine RuntimeException
	 * @throws RuntimeException
	 *             wird bei jedem Aufruf der Methode geworfen
	 * 
	 * @see java.awt.event.ComponentEvent#getComponent()
	 */
	public java.awt.Component getComponent() {
		throw new RuntimeException("not allowed");
	}

	/**
	 * Setzt die x-Koordinate. Die Methode wird Theater-intern aufgerufen.
	 * 
	 * @param x
	 *            die neue x-Koordinate
	 */
	final public void setX(int x) {
		this.x = x;
	}

	/**
	 * Setzt die y-Koordinate. Die Methode wird Theater-intern aufgerufen.
	 * 
	 * @param y
	 *            die neue y-Koordinate
	 */
	final public void setY(int y) {
		this.y = y;
	}

	/**
	 * Setzt die Spalte, ber der sich der Mauszeiger aktuell befindet. Die
	 * Methode wird Theater-intern aufgerufen.
	 * 
	 * @param col
	 *            die neue Spalte
	 */
	final public void setColumn(int col) {
		this.column = col;
	}

	/**
	 * Setzt die Reihe, ber der sich der Mauszeiger aktuell befindet. Die
	 * Methode wird Theater-intern aufgerufen.
	 * 
	 * @param row
	 *            die neue Reihe
	 */
	final public void setRow(int row) {
		this.row = row;
	}

	/**
	 * Setzt das Source-Objekt. Die Methode wird Theater-intern aufgerufen.
	 * 
	 * @param source
	 *            das neue Source-Objekt
	 */
	final public void setSource(Object source) {
		this.source = source;
	}

}
