package theater_intern;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;

import listener.Application;
import model.Play;
import sun.audio.AudioPlayer;
import sun.audio.AudioStream;
import util.ResourceLoader;

public class SoundAsStream implements SoundHandler {

	InputStream inputStream;
	AudioStream audioStream;
	ArrayList<InputStream> audios;

	public SoundAsStream() {
		this.audios = new ArrayList<InputStream>();
		this.inputStream = null;
		this.audioStream = null;
	}

	public void playSound(String soundFile) {
		String dir = Play.getPlay().getDirectory();

		if (Application.isStandAlone()) {
			try {
				this.inputStream = ResourceLoader
						.getDataFileInputStream("data/sounds/" + soundFile);
				this.audioStream = new AudioStream(this.inputStream);
				AudioPlayer.player.start(this.audioStream);
				audios.add(this.audioStream);
				audios.add(this.inputStream);
			} catch (Exception exc) {
			}
		} else {
			File f = new File(dir + File.separatorChar + "sounds"
					+ File.separatorChar + soundFile);

			if (!f.exists()) {
				throw new IllegalArgumentException();
			}
			try {
				this.inputStream = new FileInputStream(f.getAbsolutePath());
				this.audioStream = new AudioStream(this.inputStream);
				AudioPlayer.player.start(this.audioStream);
				audios.add(this.audioStream);
				audios.add(this.inputStream);
			} catch (Exception exc) {
			}
		}
	}

	public void stopSounds() {
		new SoundsStop(new ArrayList<InputStream>(this.audios)).start();
		audios = new ArrayList<InputStream>();
	}
}

class SoundsStop extends Thread {

	ArrayList<InputStream> audios;

	SoundsStop(ArrayList<InputStream> audios) {
		this.audios = audios;
	}

	public void run() {
		try {
			Thread.sleep(3000);
		} catch (InterruptedException exc) {
		}
		for (int i = 0; i < audios.size(); i += 2) {
			stopSound((AudioStream) audios.get(i), audios.get(i + 1));
		}
	}

	static void stopSound(AudioStream aStream, InputStream iStream) {
		try {
			if (aStream != null) {
				AudioPlayer.player.stop(aStream);
				aStream.close();
			}
		} catch (Throwable th) {
		}
		try {
			if (iStream != null) {
				iStream.close();
			}
		} catch (Throwable th) {
		}
	}

}
