package view;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;

import javax.swing.JComponent;
import javax.swing.SwingUtilities;

import model.Play;
import theater.Component;
import theater_intern.IStage;
import util.ResourceLoader;
import util.ResourceManager;

public class TheaterGlassPane extends JComponent implements MouseListener,
		MouseMotionListener {

	private Component comp;
	private Point mousePoint;
	private Image outside;

	public TheaterGlassPane() {
		outside = ResourceLoader.getImage("outside24.gif");
	}

	public void activate(Component comp) {
		this.comp = comp;
		this.setVisible(true);
		this.addMouseListener(this);
		this.addMouseMotionListener(this);
		mousePoint = this.getMousePosition();
	}

	public void deactivate() {
		this.setVisible(false);
		this.removeMouseListener(this);
		this.removeMouseMotionListener(this);
	}

	protected void paintComponent(Graphics g) {
		Image im = this.comp.getImage().getAwtImage();
		StagePanel stagePanel = Play.getPlay().getStagePanel();
		Point stagePoint = SwingUtilities.convertPoint(this, mousePoint,
				stagePanel);
		if (stagePanel.isInsideStage(stagePoint)) {
			Point drawPoint = SwingUtilities.convertPoint(stagePanel,
					stagePanel.getDrawPoint(stagePoint, im), this);
			g.drawImage(im, drawPoint.x + 1, drawPoint.y + 1, null);
		} else {
			g.drawImage(im, mousePoint.x - im.getWidth(Play.getPlay().getStagePanel()) / 2, mousePoint.y
					- im.getHeight(Play.getPlay().getStagePanel()) / 2, null);
			g.drawImage(outside, mousePoint.x - outside.getWidth(null) / 2,
					mousePoint.y - outside.getHeight(null) / 2, null);
		}
	}

	public void mouseMoved(MouseEvent e) {
		this.mousePoint = e.getPoint();
		repaint();
	}

	public void mousePressed(MouseEvent e) {
		String msg = "msg.nonewcomp";
		if (e.getButton() == MouseEvent.BUTTON1) {
			StagePanel stagePanel = Play.getPlay().getStagePanel();
			Point stagePoint = SwingUtilities.convertPoint(this, e.getPoint(),
					stagePanel);
			if (stagePanel.isInsideStage(stagePoint)) {
				int col = stagePanel.getCellColumn(stagePoint.x);
				int row = stagePanel.getCellRow(stagePoint.y);
				IStage.getStage(Play.getPlay().getActiveStage()).add(comp, col,
						row);
				msg = "msg.newcomp";
			}
		}
		deactivate();
		Play.getPlay().getPlayFrame().getMessagePanel().writeInfo(
				ResourceManager.getResourceManager().getValue(msg));
	}

	public void mouseClicked(MouseEvent e) {
	}

	public void mouseEntered(MouseEvent e) {
	}

	public void mouseExited(MouseEvent e) {
	}

	public void mouseReleased(MouseEvent e) {
	}

	public void mouseDragged(MouseEvent e) {
	}

}
