package compiler;

import java.util.ArrayList;

import javax.swing.JTextPane;

/**
 * Realisiert eine TextPane, in der Fehlermeldungen des Compilers ausgegeben
 * werden knnen
 * 
 * @author Dietrich Boles, Uni Oldenburg
 * @version 1.0 (12.11.2008)
 * 
 */
public class SimpleCompilerErrorPanel extends JTextPane {

	/**
	 * Erzeugt die TextPane
	 */
	public SimpleCompilerErrorPanel() {
		super();
		this.setEditable(false);
	}

	/**
	 * Gibt Fehlermeldungen aus
	 * 
	 * @param errors
	 */
	public void setErrorMessages(ArrayList<ErrorMessage> errors) {
		String txt = "";
		for (ErrorMessage msg : errors) {
			txt += msg.getMsg() + "\n";
		}
		this.setText(txt);
	}

	/**
	 * Lscht die TextPane
	 */
	public void clear() {
		this.setText("");
	}

}
