package editor.listener;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import util.ResourceManager;

import editor.Editor;

/**
 * Ausfhren einer Undo-Aktion
 * 
 * @author Dietrich Boles, Uni Oldenburg
 * @version 1.0 (12.11.2008)
 * 
 */
public class UndoListener implements ActionListener {

	Editor editor;

	public UndoListener(Editor editor) {
		this.editor = editor;
	}

	public void actionPerformed(ActionEvent e) {
		if (this.editor.getUndoManager().canUndo()) {
			this.editor.getUndoManager().undo();
			this.editor.getEditorPanel().calcNumberOfLines();
			this.editor.getEditorPanel().getJavaDocument().rehighlight();
			this.editor.setChanged(true);
			this.editor.getMessagePanel().writeInfo(
					ResourceManager.getResourceManager().getValue(
							"msg.editor.undo"));
		}
		this.editor.getEditorPanel().requestFocusInWindow();
	}

}
