package listener;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import javax.swing.JOptionPane;
import javax.swing.JTextField;

import model.Play;
import theater_intern.TheaterObservable;
import util.ResourceManager;
import util.Utils;

/**
 * Listener zum Ausfhren einer Methode (mit Parameter)
 * 
 * @author Dietrich Boles, Uni Oldenburg
 * @version 1.0 (12.11.2008)
 * 
 */
public class MethodWithParamInvocation implements ActionListener {

	Method method;
	Object obj;
	ResourceManager man;
	MethodWithParamThread thread;

	public MethodWithParamInvocation(Method m, Object o) {
		this.method = m;
		this.obj = o;
		this.man = ResourceManager.getResourceManager();
	}

	public void actionPerformed(ActionEvent e) {
		try {
			Play.getPlay().setEventQueueActive(true);
			Object[] params = this.getParams();
			if (params == null) {
				return;
			}
			TheaterObservable.getObservable().setEnabled(false);
			this.thread = new MethodWithParamThread(this, params);
			this.thread.start();
			this.thread.join(MethodInvocation.WAIT_TIME);
			// wenn die Ausfhrung einer Methode lnger als eine bestimmte
			// Schwelle berschreitet, wird sie abgebrochen; das verhindert
			// Endlosschleifen
			if (this.thread.isAlive()) {
				this.thread.stop();
				this.thread.join();
				TheaterObservable.getObservable().setEnabled(true);
			} else {
				TheaterObservable.getObservable().setEnabled(true);
				TheaterObservable.getObservable().importantStateChange();
				this.showResult();
			}
		} catch (Throwable exc) {
			exc.printStackTrace();
		} finally {
			Play.getPlay().setEventQueueActive(false);
		}

	}

	Object[] getParams() {
		Object[] lines = new Object[this.method.getParameterTypes().length * 2 + 1];
		lines[0] = this.method.getName();
		int f = 1;
		for (Class<?> cls : this.method.getParameterTypes()) {
			lines[f++] = cls.getName();
			lines[f++] = new JTextField();
		}
		Object[] options = { this.man.getValue("callmethod"),
				this.man.getValue("cancel") };
		int n = JOptionPane.showOptionDialog(Play.getPlay().getStagePanel(),
				lines, this.man.getValue("callmethod"),
				JOptionPane.YES_NO_OPTION, JOptionPane.PLAIN_MESSAGE, null,
				options, options[0]);
		if (n == JOptionPane.YES_OPTION) {
			try {
				Object[] params = new Object[this.method.getParameterTypes().length];
				f = 0;
				for (Class<?> cls : this.method.getParameterTypes()) {
					params[f] = ((JTextField) lines[f * 2 + 2]).getText();
					if (cls == int.class || cls == Integer.class) {
						params[f] = Integer.parseInt((String) params[f]);
					} else if (cls == short.class || cls == Short.class) {
						params[f] = Short.parseShort((String) params[f]);
					} else if (cls == long.class || cls == Long.class) {
						params[f] = Long.parseLong((String) params[f]);
					} else if (cls == float.class || cls == Float.class) {
						params[f] = Float.parseFloat((String) params[f]);
					} else if (cls == double.class || cls == Double.class) {
						params[f] = Double.parseDouble((String) params[f]);
					} else if (cls == boolean.class || cls == Boolean.class) {
						params[f] = Boolean.parseBoolean((String) params[f]);
					} else if (cls == char.class || cls == Character.class) {
						params[f] = new Character(((String) params[f])
								.charAt(0));
					}
					f++;
				}
				return params;
			} catch (final Throwable th) {
				EventQueue.invokeLater(new Runnable() {
					public void run() {
						TheaterObservable.getObservable().importantStateChange();
						JOptionPane.showMessageDialog(Play.getPlay()
								.getStagePanel(),
								MethodWithParamInvocation.this.man
										.getValue("callmethoderror"), th
										.getClass().getName(),
								JOptionPane.INFORMATION_MESSAGE);
					}
				});
				return null;
			}
		} else {
			return null;
		}
	}

	void showResult() {
		if (thread.result == null) {
			return;
		}
		JOptionPane
				.showMessageDialog(Play.getPlay().getStagePanel(), method
						.getName()
						+ " "
						+ MethodWithParamInvocation.this.man
								.getValue("returnvalue")
						+ " "
						+ thread.result.toString(),
						MethodWithParamInvocation.this.man
								.getValue("callmethodresult"),
						JOptionPane.INFORMATION_MESSAGE);
	}
}

class MethodWithParamThread extends Thread {

	MethodWithParamInvocation in;
	Object[] params;
	Object result;

	MethodWithParamThread(MethodWithParamInvocation in, Object[] params) {
		this.in = in;
		this.params = params;
	}

	public void run() {
		this.result = null;
		try {
			this.result = this.in.method.invoke(this.in.obj, this.params);
		} catch (InvocationTargetException exc) {
			final Throwable th = exc.getTargetException();
			if (Utils.dynInstanceof(th, ThreadDeath.class)) {
				EventQueue.invokeLater(new Runnable() {
					public void run() {
						JOptionPane
								.showMessageDialog(Play.getPlay()
										.getStagePanel(), ResourceManager
										.getResourceManager().getValue(
												"msg.methodcallstopped"),
										ResourceManager.getResourceManager()
												.getValue("msg.error"),
										JOptionPane.ERROR_MESSAGE);
						Play.getPlay().reset(); // alles neu laden, weil in
						// undefiniertem Zustand
					}
				});
			} else {
				EventQueue.invokeLater(new Runnable() {
					public void run() {
						TheaterObservable.getObservable().importantStateChange();
						JOptionPane.showMessageDialog(Play.getPlay()
								.getStagePanel(), th.getMessage(), th
								.getClass().getName(),
								JOptionPane.INFORMATION_MESSAGE);
					}
				});
			}

		} catch (final Throwable exc) {
			EventQueue.invokeLater(new Runnable() {
				public void run() {
					TheaterObservable.getObservable().importantStateChange();
					JOptionPane.showMessageDialog(Play.getPlay()
							.getStagePanel(), MethodWithParamThread.this.in.man
							.getValue("callmethoderror"), exc.getClass()
							.getName(), JOptionPane.INFORMATION_MESSAGE);
				}
			});
		}

	}
}
