package listener;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileView;

import model.Play;
import util.ResourceLoader;

/**
 * ffnen eines existierenden Theaterstckes
 * 
 * @author Dietrich Boles, Uni Oldenburg
 * @version 1.0 (12.11.2008)
 * 
 */
public class OpenPlayListener implements ActionListener {

	private static OpenPlayListener manager = null;

	private JFileChooser chooser;

	public static OpenPlayListener getOpenPlayManager() {
		if (OpenPlayListener.manager == null) {
			OpenPlayListener.manager = new OpenPlayListener();
		}
		return OpenPlayListener.manager;
	}

	protected OpenPlayListener() {
		if (Application.isApplet()) {
			return;
		}
		if (Application.eclipseOption()) {
			this.chooser = new JFileChooser("plays");
		} else {
			this.chooser = new JFileChooser(".");
		}
		// FileNameExtensionFilter filter = new FileNameExtensionFilter(
		// ResourceManager.getResourceManager().getValue(
		// "filechooser.open.typedesc"), "theater");
		// this.chooser.setFileFilter(filter);
		this.chooser.setAcceptAllFileFilterUsed(false);
		this.chooser.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);
		this.chooser.setFileView(new TheaterFileView());
	}

	public void actionPerformed(ActionEvent e) {
		int returnVal = this.chooser.showOpenDialog(Play.getPlay()
				.getPlayFrame());
		if (returnVal == JFileChooser.APPROVE_OPTION) {
			String theaterDir = this.chooser.getSelectedFile()
					.getAbsolutePath();
			try {
				if (Application.eclipseOption()) {
					ProcessBuilder builder = new ProcessBuilder("java",
							Application.class.getName(),
							Application.ECLIPSE_OPTION,
							Application.EXISTING_PLAY_OPTION, theaterDir);
					builder.start();
				} else {
					ProcessBuilder builder = new ProcessBuilder("java", "-jar",
							Application.JAR_NAME,
							Application.EXISTING_PLAY_OPTION, theaterDir);
					builder.start();
				}

			} catch (Throwable exc) {
				exc.printStackTrace();
			}
		}
	}

}

class TheaterFileView extends FileView {

	ImageIcon theaterIcon = ResourceLoader.getImageIcon("actor.gif");

	public Boolean isTraversable(File f) {
		if (f.isDirectory()) {
			File[] files = f.listFiles();
			for (File file : files) {
				if (file.getName().equals("theater.xml")) {
					return false;
				}
			}
		}
		return super.isTraversable(f);
	}

	public Icon getIcon(File f) {
		if (f == null) {
			return super.getIcon(f);
		}

		if (f.getName().equals("")) {
			return super.getIcon(f);
		}

		// don't try to test Windows root directories (you'll get in
		// trouble with disks that are not in drives...).
		if (f.getPath().endsWith(":\\")) {
			return super.getIcon(f);
		}

		if (!f.isDirectory()) {
			return super.getIcon(f);
		}
		
		File packageFile = new File(f, "theater.xml");
		if (packageFile.exists()) {
			return this.theaterIcon;
		}
		

		// File[] files = f.listFiles();
		// for (File file : files) {
		// if (file.getName().equals("theater.xml")) {
		// return this.theaterIcon;
		// }
		// }

		return super.getIcon(f);
	}
}
