package theater;

import model.Play;

/**
 * Die Klasse Cell reprsentiert eine Zelle der Bhne. Sie implementiert das
 * Interface PixelArea, so dass mit dieser Klasse Kollisionen von Zellen mit
 * anderen Gebieten der Bhne berprft werden knnen.
 * 
 * @author Dietrich Boles, Universitt Oldenburg, Germany
 * @version 1.0 (08.09.2009)
 * 
 */
public class Cell implements PixelArea {

	/**
	 * Reihe der Zelle
	 */
	protected int row;

	/**
	 * Spalte der Zelle
	 */
	protected int col;

	/**
	 * Konstruktor zum Initialisieren einer Zelle mit seiner Spalte und Reihe.
	 * 
	 * @param col
	 *            die Spalte der Zelle
	 * @param row
	 *            die Reihe der Zelle
	 */
	public Cell(int col, int row) {
		this.col = col;
		this.row = row;
	}

	/**
	 * berprft, ob der Punkt mit den als Parameter bergebenen Koordinaten
	 * innerhalb der aufgerufenen Zelle liegt.
	 * 
	 * @param x
	 *            x-Koordinate des Punktes
	 * @param y
	 *            y-Koordinate des Punktes
	 * @return genau dann true, wenn der Punkt mit den als Parameter bergebenen
	 *         Koordinaten innerhalb der aufgerufenen Zelle liegt
	 * 
	 * @see theater.PixelArea#contains(int, int)
	 */
	public boolean contains(int x, int y) {
		return new Rectangle(Play.getPlay().getStagePanel().getCellRectangle(
				row, col)).contains(x, y);
	}

	/**
	 * berprft, ob die aufgerufene Zelle innerhalb der als Parameter
	 * bergebenen PixelArea liegt.
	 * 
	 * @param area
	 *            die zu vergleichende PixelArea
	 * @return genau dann true, wenn die aufgerufene Zelle innerhalb der als
	 *         Parameter bergebenen PixelArea liegt
	 * 
	 * @see theater.PixelArea#isInside(theater.PixelArea)
	 */
	public boolean isInside(PixelArea area) {
		return new Rectangle(Play.getPlay().getStagePanel().getCellRectangle(
				row, col)).isInside(area);
	}

	/**
	 * berprft, ob die aufgerufene Zelle die als Parameter bergebene
	 * PixelArea schneidet.
	 * 
	 * @param area
	 *            die zu vergleichende PixelArea
	 * @return genau dann true, wenn die aufgerufene Zelle die als Parameter
	 *         bergebene PixelArea schneidet
	 * @see theater.PixelArea#intersects(theater.PixelArea)
	 */
	public boolean intersects(PixelArea area) {
		return new Rectangle(Play.getPlay().getStagePanel().getCellRectangle(
				row, col)).intersects(area);
	}

	/**
	 * Liefert die Spalte der Zelle.
	 * 
	 * @return die Spalte der Zelle
	 */
	public int getCol() {
		return this.col;
	}

	/**
	 * Liefert die Reihe der Zelle.
	 * 
	 * @return die Reihe der Zelle
	 */
	public int getRow() {
		return this.row;
	}
}
