package theater;

import java.awt.Container;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.File;
import java.net.URL;

import listener.Application;
import model.Play;
import util.ResourceLoader;

/**
 * TheaterIcon ist eine von der Theater-Klasse TheaterImage abgeleitete Klasse,
 * die die Verwendung von Animated-GIF-Ikons ermglicht.
 * <p>
 * </p>
 * Achtung: Die meisten Methoden dieser Klasse berschreiben die von der Klasse
 * TheaterImage geerbten Methoden als leere Methoden, da Animated-GIFs nicht
 * manipuliert werden knnen!
 * 
 * @author Dietrich Boles, Universitt Oldenburg, Germany
 * @version 1.0 (08.09.2009)
 * 
 */
public class TheaterIcon extends TheaterImage {

	/**
	 * intern verwendetes Attribut
	 */
	transient private Image image;

	/**
	 * intern verwendetes Attribut
	 */
	private String filename;

	/**
	 * Konstruktor zum Initialisieren eines TheaterIcons mit einem Bild aus
	 * einer Datei. Erlaubte Bildformate sind gif, jpq und png.
	 * 
	 * @param filename
	 *            Name der Bilddatei; die Datei muss sich im Unterverzeichnis
	 *            "images" des Theaterstcks befinden
	 * @throws IllegalArgumentException
	 *             wird geworfen, wenn die Datei nicht existiert, keine gltige
	 *             Bilddatei ist oder nicht lesbar ist
	 */
	public TheaterIcon(String filename) throws IllegalArgumentException {
		super();

		this.filename = filename;
		if (Application.isApplet()) {
			this.initApplet();
		} else if (Application.isStandAlone()) {
			this.initSA();
		} else {
			this.init();
		}

	}

	/**
	 * Liefert die Breite des TheaterImages in Pixeln.
	 * 
	 * @return die Breite des TheaterImages in Pixeln
	 */
	public int getWidth() {

		return this.image.getWidth(Play.getPlay().getStagePanel());

	}

	/**
	 * Liefert die Hhe des TheaterImages in Pixeln.
	 * 
	 * @return die Hhe des TheaterImages in Pixeln
	 */
	public int getHeight() {

		return this.image.getHeight(Play.getPlay().getStagePanel());

	}

	/**
	 * Ordnet dem TheaterImage eine Farbe zu, in der bei Aufruf der draw- bzw.
	 * fill-Methoden die entsprechenden Graphik-Primitiven gezeichnet werden.
	 * 
	 * @param color
	 *            die neue Zeichenfarbe
	 */
	public void setColor(java.awt.Color color) {

	}

	/**
	 * Liefert die aktuelle Zeichenfarbe des TheaterImages.
	 * 
	 * @return die aktuelle Zeichenfarbe des TheaterImages
	 */
	public java.awt.Color getColor() {

		return null;
	}

	/**
	 * Setzt den Font, in dem Texte durch nachfolgende Aufrufe der
	 * drawString-Methode in dem TheaterImage gezeichnet werden sollen.
	 * 
	 * @param f
	 *            der neue Font
	 */
	public void setFont(java.awt.Font f) {

	}

	/**
	 * Liefert den aktuellen Font des TheaterImages.
	 * 
	 * @return der aktuelle Font des TheaterImages
	 */
	public java.awt.Font getFont() {

		return null;
	}

	/**
	 * Zeichnet im TheaterImage eine Linie in der aktuellen Zeichenfarbe.
	 * 
	 * @param x1
	 *            x-Koordinate, von der aus die Linie gezeichnet werden soll
	 * @param y1
	 *            y-Koordinate, von der aus die Linie gezeichnet werden soll
	 * @param x2
	 *            x-Koordinate, bis wohin die Linie gezeichnet werden soll
	 * @param y2
	 *            y-Koordinate, bis wohin die Linie gezeichnet werden soll
	 */
	public void drawLine(int x1, int y1, int x2, int y2) {

	}

	/**
	 * Zeichnet im TheaterImage ein Rechteck in der aktuellen Zeichenfarbe.
	 * 
	 * @param x
	 *            x-Koordinate der linken oberen Ecke des Rechtecks
	 * @param y
	 *            y-Koordinate der linken oberen Ecke des Rechtecks
	 * @param width
	 *            Breite des Rechtecks (in Pixeln)
	 * @param height
	 *            Hhe des Rechtecks (in Pixeln)
	 */
	public void drawRect(int x, int y, int width, int height) {

	}

	/**
	 * Zeichnet im TheaterImage ein Oval in der aktuellen Zeichenfarbe.
	 * 
	 * @param x
	 *            x-Koordinate der linken oberen Ecke des Ovals
	 * @param y
	 *            y-Koordinate der linken oberen Ecke des Ovals
	 * @param width
	 *            Breite des Ovals in Pixeln
	 * @param height
	 *            Hhe des Ovals in Pixeln
	 */
	public void drawOval(int x, int y, int width, int height) {

	}

	/**
	 * Zeichnet im TheaterImage ein Polygon in der aktuellen Zeichenfarbe. Es
	 * wird automatisch ein Linie hinzugefgt, die das Polygon schliet.
	 * 
	 * @param xPoints
	 *            x-Koordinaten der Linien
	 * @param yPoints
	 *            y-Koordinaten der Linien
	 * @param nPoints
	 *            Anzahl der Liniensegmente
	 */
	public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {

	}

	/**
	 * Zeichnet im TheaterImage einen Text im aktuell gesetzten Font.
	 * 
	 * @param string
	 *            der zu zeichnende Text
	 * @param x
	 *            x-Koordinate, an der der Text beginnen soll
	 * @param y
	 *            y-Koordinate, an der der Text beginnen soll
	 */
	public void drawString(String string, int x, int y) {

	}

	/**
	 * Zeichnet ein existierendes TheaterImage an einer bestimmten Stelle in das
	 * aufgerufene TheaterImage
	 * 
	 * @param image
	 *            das TheaterImage, das gezeichnet werden soll (darf nicht null
	 *            sein)
	 * @param x
	 *            x-Koordinate, an der das Image gezeichnet werden soll
	 * @param y
	 *            y-Koordinate, an der das Image gezeichnet werden soll
	 */
	public void drawImage(TheaterIcon image, int x, int y) {

	}

	/**
	 * Fllt das gesamte TheaterImage in der aktuellen Zeichenfarbe.
	 */
	public void fill() {

	}

	/**
	 * Zeichnet im TheaterImage ein geflltes Rechteck in der aktuellen
	 * Zeichenfarbe.
	 * 
	 * @param x
	 *            x-Koordinate der linken oberen Ecke des Rechtecks
	 * @param y
	 *            y-Koordinate der linken oberen Ecke des Rechtecks
	 * @param width
	 *            Breite des Rechtecks (in Pixeln)
	 * @param height
	 *            Hhe des Rechtecks (in Pixeln)
	 */
	public void fillRect(int x, int y, int width, int height) {

	}

	/**
	 * Zeichnet im TheaterImage ein geflltes Oval in der aktuellen
	 * Zeichenfarbe.
	 * 
	 * @param x
	 *            x-Koordinate der linken oberen Ecke des Ovals
	 * @param y
	 *            y-Koordinate der linken oberen Ecke des Ovals
	 * @param width
	 *            Breite des Ovals in Pixeln
	 * @param height
	 *            Hhe des Ovals in Pixeln
	 */
	public void fillOval(int x, int y, int width, int height) {

	}

	/**
	 * Zeichnet im TheaterImage ein geflltes Polygon in der aktuellen
	 * Zeichenfarbe. Es wird automatisch ein Linie hinzugefgt, die das Polygon
	 * schliet.
	 * 
	 * @param xPoints
	 *            x-Koordinaten der Linien
	 * @param yPoints
	 *            y-Koordinaten der Linien
	 * @param nPoints
	 *            Anzahl der Liniensegmente
	 */
	public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {

	}

	/**
	 * Lscht ein TheaterImage.
	 */
	public void clear() {

	}

	/**
	 * Setzt ein bestimmtes Pixel des TheaterImages auf eine bestimmte Farbe.
	 * 
	 * @param x
	 *            x-Koordinate des Pixels
	 * @param y
	 *            y-Koordinate des Pixels
	 * @param color
	 *            neue Farbe des Pixels
	 */
	public void setColorAt(int x, int y, java.awt.Color color) {

	}

	/**
	 * Liefert die Farbe eines bestimmten Pixels des TheaterImages.
	 * 
	 * @param x
	 *            x-Koordinate des Pixels
	 * @param y
	 *            y-Koordinate des Pixels
	 * @return die Farbe eines bestimmten Pixels des TheaterImages
	 */
	public java.awt.Color getColorAt(int x, int y) {

		return null;
	}

	/**
	 * Spiegelt das TheaterImage horizontal. Achtung: Die Gre des Bildes wird
	 * dabei nicht verndert!
	 */
	public void mirrorHorizontally() {

	}

	/**
	 * Spiegelt das TheaterImage vertikal. Achtung: Die Gre des Bildes wird
	 * dabei nicht verndert!
	 */
	public void mirrorVertically() {

	}

	/**
	 * Dreht das TheaterImage um eine bestimmte Gradzahl. Achtung: Die Gre des
	 * Bildes wird dabei nicht verndert!
	 * 
	 * @param degrees
	 *            Gradzahl der Drehung
	 */
	public void rotate(int degrees) {

	}

	/**
	 * Skaliert das TheaterImage auf eine bestimmte Gre.
	 * 
	 * @param width
	 *            die neue Breite des TheaterImages
	 * @param height
	 *            die neue Hhe des TheaterImages
	 */
	public void scale(int width, int height) {

	}

	/**
	 * Intern wird ein TheaterImage durch ein
	 * java.awt.image.BufferedImage-Objekt realisiert. Diese Methode liefert das
	 * entsprechende Objekt. Achtung: Einige Methoden tauschen intern das
	 * BufferedImage-Objekt aus!
	 * 
	 * @return das aktuelle interne Image-Objekt
	 */
	public java.awt.Image getAwtImage() {

		return this.image;

	}

	// interne Methoden

	/**
	 * interne Methode zur Initialisierung
	 * 
	 * @throws IllegalArgumentException
	 */
	private void init() throws IllegalArgumentException {
		try {
			File f = new File(Play.getPlay().getDirectory() + "/" + "images"
					+ "/" + this.filename);
			if (!f.exists()) {
				throw new IllegalArgumentException();
			}
			MediaTracker tracker = new MediaTracker(new Container());
			URL url = f.toURI().toURL();
			this.image = Toolkit.getDefaultToolkit().createImage(url);
			tracker.addImage(this.image, 1);
			tracker.waitForID(1);
		} catch (Throwable e) {
			throw new IllegalArgumentException(e.getMessage());
		}
	}

	/**
	 * interne Methode zur Initialisierung (Standalone)
	 * 
	 * @throws IllegalArgumentException
	 */
	private void initSA() throws IllegalArgumentException {
		try {
			URL url = ResourceLoader.getDataFileURL("data/images"
					+ this.filename);
			this.image = Toolkit.getDefaultToolkit().createImage(url);
			MediaTracker tracker = new MediaTracker(new Container());
			tracker.addImage(this.image, 1);
			tracker.waitForID(1);
		} catch (Throwable e) {
			throw new IllegalArgumentException(e.getMessage());
		}
	}

	/**
	 * interne Methode zur Initialisierung (Standalone)
	 * 
	 * @throws IllegalArgumentException
	 */
	private void initApplet() throws IllegalArgumentException {
		try {
			MediaTracker tracker = new MediaTracker(new Container());
			URL url = TheaterImage.class.getClassLoader().getResource(
					"data/images/" + this.filename);
			this.image = Toolkit.getDefaultToolkit().createImage(url);
			tracker.addImage(this.image, 1);
			tracker.waitForID(1);
		} catch (Throwable exc) {
			exc.printStackTrace();
			throw new IllegalArgumentException();
		}
	}

}
