package util;

import java.util.Locale;
import java.util.ResourceBundle;

/**
 * Verwaltet das ResourceBundle. Dieses befindet sich im Unterverzeichnis
 * resources der Theater-jar-Datei und trgt den Namen "theater"
 * 
 * @author Dietrich Boles, Uni Oldenburg
 * @version 1.0 (12.11.2008)
 * 
 */
public class ResourceManager {

	private static ResourceManager manager = null;
	private ResourceBundle bundle;

	/**
	 * Erzeugt den ResourceManager entsprechend einer bergebenen Locale. Der
	 * ResourceManager verwaltet das entsprechende ResourceBundle.
	 * 
	 * @param locale
	 */
	protected ResourceManager(Locale locale) {
		this.bundle = ResourceBundle.getBundle("resources.theater", locale);
	}

	/**
	 * Liefert den ResourceManager entsprechend der in den Properties gewhlten
	 * Locale.
	 * 
	 * @return
	 */
	public static ResourceManager getResourceManager() {
		PropertyManager pManager = PropertyManager.getPropertyManager();
		return ResourceManager.getResourceManager(pManager.getLocale());
	}

	/**
	 * Liefert den ResourceManager entsprechend der bergebenen Locale.
	 * 
	 * @param locale
	 * @return
	 */
	protected static ResourceManager getResourceManager(Locale locale) {
		if (ResourceManager.manager == null) {
			ResourceManager.manager = new ResourceManager(locale);
		}
		return ResourceManager.manager;
	}

	/**
	 * Liefert den Wert der bergebenen Resource.
	 * 
	 * @param key
	 * @return
	 */
	public String getValue(String key) {
		return this.bundle.getString(key);
	}
}
