package view;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;

import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

import listener.MethodInvocation;
import listener.MethodWithParamInvocation;
import listener.RemoveComponentListener;
import theater.Component;
import theater_intern.IComponent;
import util.ResourceManager;

/**
 * Popup-Menu fr Componenten
 * 
 * @author Dietrich Boles, Uni Oldenburg
 * @version 1.0 (12.11.2008)
 * 
 */
public class ComponentPopupMenu extends JPopupMenu {

	public ComponentPopupMenu(IComponent icomp) {
		MethodComparator comparator = new MethodComparator();

		Component comp = IComponent.getComp(icomp);
		Class<?> cls = comp.getClass();
		do {
			cls = cls.getSuperclass();
			Method[] methods = this.getMethods(comp, cls);
			Arrays.sort(methods, comparator);
			JMenu menu = new JMenu(cls.getName());
			for (Method method : methods) {
				JMenuItem m = new JMenuItem(this.genMethodName(method));
				if (method.getParameterTypes().length == 0) {
					m.addActionListener(new MethodInvocation(method, comp));
				} else {
					m.addActionListener(new MethodWithParamInvocation(method,
							comp));
				}
				menu.add(m);
			}
			if (methods.length == 0) {
				JMenuItem m = new JMenuItem(ResourceManager
						.getResourceManager().getValue("nomethod"));
				m.setEnabled(false);
				menu.add(m);
			}
			this.add(menu);
		} while (cls != Object.class);

		Method[] methods = this.getMethods(comp, comp.getClass());
		Arrays.sort(methods, comparator);
		for (Method method : methods) {
			JMenuItem m = new JMenuItem(this.genMethodName(method));
			if (method.getParameterTypes().length == 0) {
				m.addActionListener(new MethodInvocation(method, comp));
			} else {
				m
						.addActionListener(new MethodWithParamInvocation(
								method, comp));
			}
			this.add(m);
		}
		this.addSeparator();
		JMenuItem rem = new JMenuItem(ResourceManager.getResourceManager()
				.getValue("actor.remove"));
		rem.addActionListener(new RemoveComponentListener(icomp));
		this.add(rem);
	}

	public Method[] getMethods(Component c, Class<?> cls) {
		ArrayList<Method> res = new ArrayList<Method>();
		for (Method method : c.getClass().getMethods()) {
			if (Modifier.isPublic(method.getModifiers())
					&& !Modifier.isAbstract(method.getModifiers())
					// && !Modifier.isStatic(method.getModifiers())
					&& method.getDeclaringClass() == cls) {
				res.add(method);
			}
		}
		return res.toArray(new Method[0]);
	}

	public String genMethodName(Method method) {
		String str = new String();

		str += method.getReturnType().getName();
		str += " " + method.getName() + "(";

		Class<?>[] parameterTypes = method.getParameterTypes();
		for (int k = 0; k < parameterTypes.length; k++) {
			str += parameterTypes[k].getName();
			if (k < parameterTypes.length - 1) {
				str += ", ";
			}
		}
		str += " )";
		return str;
	}
}
