package view;

import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.net.URL;

import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingConstants;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.filechooser.FileView;

import sun.audio.AudioPlayer;
import sun.audio.AudioStream;
import util.ResourceLoader;
import util.ResourceManager;

/**
 * Chooser zum Auswhlen eines Sounds
 * 
 * @author Dietrich Boles, Uni Oldenburg
 * @version 1.0 (12.11.2008)
 * 
 */
public class JSoundChooser extends JFileChooser {

	PreListenPanel prelistenPane;

	public JSoundChooser() {
		super();
		this.prelistenPane = new PreListenPanel();
		this.setAcceptAllFileFilterUsed(false);
		this.setAccessory(this.prelistenPane);
		this.addPropertyChangeListener(this.prelistenPane);
		FileNameExtensionFilter filter = new FileNameExtensionFilter(
				ResourceManager.getResourceManager().getValue(
						"soundchooser.open.typedesc"), "wav", "au", "aiff");
		this.setFileFilter(filter);
		this.setFileView(new SoundFileView());
		this.setMultiSelectionEnabled(true);
	}
	
	public void stopSound() {
		this.prelistenPane.stopSound();
	}

}

class PreListenPanel extends JPanel implements PropertyChangeListener {
	private JLabel imgLabel;
	private JLabel infoLabel;
	private Icon imgIcon;
	private AudioClip clip;
	private URL url;
	private File newFile;
	private FileInputStream inputStream;
	private AudioStream audioStream;

	public PreListenPanel() {
		this.setLayout(new BorderLayout(5, 5));
		this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
		this.add(new JLabel("Pre-Listen:"), BorderLayout.NORTH);
		this.imgLabel = new JLabel();
		this.imgIcon = ResourceLoader.getImageIcon("sound-big.png");
		this.imgLabel.setBackground(Color.WHITE);
		this.imgLabel.setOpaque(true);
		this.imgLabel.setHorizontalAlignment(SwingConstants.CENTER);
		this.imgLabel.setPreferredSize(new Dimension(128, 128));
		this.imgLabel.setBorder(BorderFactory.createEtchedBorder());
		this.add(this.imgLabel, BorderLayout.CENTER);
		this.infoLabel = new JLabel();
		this.add(this.infoLabel, BorderLayout.SOUTH);
		this.clip = null;
		this.newFile = null;
		this.inputStream = null;
		this.audioStream = null;
	}

	public void propertyChange(PropertyChangeEvent evt) {
		if (JFileChooser.SELECTED_FILE_CHANGED_PROPERTY.equals(evt
				.getPropertyName())) {
			stopSound();
			this.newFile = (File) evt.getNewValue();
		} else {
			this.newFile = null;
		}
		this.showContent();
	}

	void showContent() {
		if (this.newFile != null) {
			String path = this.newFile.getAbsolutePath();
			if (path.toLowerCase().endsWith(".wav")
					|| path.toLowerCase().endsWith(".au")
					|| path.toLowerCase().endsWith(".aiff")) {
				playSound(this.newFile);
				String infoText = this.newFile.length() / 1024 + " KB";
				this.imgLabel.setIcon(this.imgIcon);
				this.infoLabel.setText(infoText);
				this.repaint();
				return;
			}
		}
//		 this.imgLabel.setIcon(null);
//		 this.infoLabel.setText("");
		this.repaint();
	}

	public void playSound(File soundFile) {
		try {
			inputStream = new FileInputStream(soundFile);
			audioStream = new AudioStream(inputStream);
			AudioPlayer.player.start(audioStream);
		} catch (Exception exc) {
		}
	}

	public void stopSound() {
		try {
			if (audioStream != null) {
				AudioPlayer.player.stop(audioStream);
				audioStream.close();
				audioStream = null;
			}
		} catch (Throwable th) {
		}
		try {
			if (inputStream != null) {
				inputStream.close();
				inputStream = null;
			}
		} catch (Throwable th) {
		}
	}

	public void playSound2(File soundFile) {
		try {
			url = soundFile.toURI().toURL();
			clip = Applet.newAudioClip(url);
			clip.play();
		} catch (Exception exc) {
		}
	}

	public void stopSound2() {
		if (this.clip != null) {
			this.clip.stop();
			this.clip = null;
		}

	}
}

class SoundFileView extends FileView {

	public Icon getIcon(File f) {
		String path = f.getAbsolutePath();
		if (path.toLowerCase().endsWith(".wav")
				|| path.toLowerCase().endsWith(".au")
				|| path.toLowerCase().endsWith(".aiff")) {
			return ResourceLoader.getImageIcon("sound.png");
		}
		return super.getIcon(f);
	}

}
