package view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.Collection;
import java.util.Observable;
import java.util.Observer;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingConstants;
import javax.swing.WindowConstants;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeSelectionModel;

import listener.Application;
import listener.FileTreePopupListener;
import listener.GenerateListener;
import listener.LoadImageListener;
import listener.LoadSoundListener;
import listener.NewPlayListener;
import listener.OpenPlayListener;
import listener.QuitListener;
import listener.SavePlayListener;
import listener.SpeedListener;
import model.ClassManager;
import model.Play;
import model.TheaterClass;
import simulation.ActSimulationManager;
import simulation.SimulationManager;
import theater.Performance;
import util.ResourceLoader;
import util.ResourceManager;
import util.Utils;

import compiler.CompileManager;

import editor.Editor;

public class PlayFrame extends JFrame implements WindowListener, Observer {

	JMenuBar menuBar;

	JMenu playMenu;
	JMenu controlsMenu;
	JMenu mediaMenu;
	JMenu helpMenu;

	JMenu openRecentSubMenu;

	JMenuItem newMenuItem;
	JMenuItem openMenuItem;
	JMenuItem openRecentMenuItem;
	JMenuItem closeMenuItem;
	JMenuItem saveMenuItem;
	JMenuItem saveAsMenuItem;
	JMenuItem exportMenuItem;
	JMenuItem quitMenuItem;

	JMenuItem recent1;
	JMenuItem recent2;

	JMenuItem imagesMenuItem;
	JMenuItem audioMenuItem;

	JMenuItem manualMenuItem;
	JMenuItem apiMenuItem;
	JMenuItem aboutMenuItem;

	JToolBar toolBar;

	JButton newButton;
	JButton openButton;
	JButton saveButton;
	JButton infoButton;
	JButton compileButton;
	JButton runButton;
	MyButton stopButton;
	JButton resetButton;
	JSlider speedSlider;

	JMenuItem runMenuItem;
	JMenuItem stopMenuItem;
	JMenuItem resetMenuItem;

	Color compileBackgroundColor;
	boolean compiled;

	JSplitPane splitPane;
	JPanel fileTreeSurrounding;
	FileTree fileTree;
	FilePopupMenu filePopupMenu1;
	JPopupMenu dirPopupMenu;
	StagePanel stage;
	JScrollPane stageScrollPane;

	TheaterGlassPane glassPane;

	MessagePanel messagePanel;

	ResourceManager resourceManager;

	Play play;

	ActSimulationManager simulationManager;

	public PlayFrame(Play play) {
		super(
				!play.isEmpty() ? (play.getName().equals("data") ? "Objekt-Theater - Performance"
						: "Objekt-Theater - " + play.getName())
						: "Objekt-Theater");
		this.setDefaultCloseOperation(WindowConstants.DO_NOTHING_ON_CLOSE);
		this.play = play;
		this.compiled = true;
		this.addWindowListener(this);
		this.setLayout(new BorderLayout());
		this.resourceManager = ResourceManager.getResourceManager();
		CompileManager.getCompileManager().addObserver(this);

		this.initComponents();
		this.glassPane = new TheaterGlassPane();
		this.setGlassPane(this.glassPane);
		this.glassPane.setVisible(false);

		this.handleSimulation();

		this.setFocusable(true);
		this.pack();
		if (Application.isStandAlone()) {
			this.setResizable(false);
		}
		Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
		this.setLocation((d.width - this.getSize().width) / 2, (d.height - this
				.getSize().height) / 2);
	}

	public MessagePanel getMessagePanel() {
		return this.messagePanel;
	}

	public JButton getCompileButton() {
		return this.compileButton;
	}

	public JButton getResetButton() {
		return this.resetButton;
	}

	public StagePanel getStagePanel() {
		return this.stage;
	}

	public FileTree getFileTree() {
		return this.fileTree;
	}

	public TheaterGlassPane getGlassPane() {
		return this.glassPane;
	}

	public JScrollPane getStageScrollPane() {
		return stageScrollPane;
	}

	protected void initComponents() {
		this.initMenues();
		this.initToolBar();
		this.initFileTree();
		this.initStage();
		this.initMessagePanel();

		if (!Application.isStandAlone()) {
			this.splitPane = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT);
			this.splitPane.setBorder(BorderFactory
					.createLineBorder(Color.DARK_GRAY));
			JScrollPane fts = new JScrollPane(this.fileTreeSurrounding);
			fts.setMinimumSize(new Dimension(100, 0));
			fts.setPreferredSize(new Dimension(150, 200));
			this.splitPane.setLeftComponent(fts);
			this.splitPane.setRightComponent(stageScrollPane = new JScrollPane(
					this.stage));
			this.splitPane.setOneTouchExpandable(true);
			this.splitPane.setContinuousLayout(true);
			this.add(this.splitPane, BorderLayout.CENTER);
			this.add(this.messagePanel, BorderLayout.SOUTH);
		} else {
			this.add(this.stage, BorderLayout.CENTER);
		}
	}

	protected void initMenues() {
		this.menuBar = new JMenuBar();
		this.initPlayMenu();
		this.menuBar.add(this.playMenu);

		this.mediaMenu = new JMenu(this.resourceManager
				.getValue("menu.media.text"));
		this.initMediaMenu();
		this.menuBar.add(this.mediaMenu);
		if (this.play.isEmpty()) {
			this.mediaMenu.setEnabled(false);
		}

		this.controlsMenu = new JMenu(this.resourceManager
				.getValue("menu.controls.text"));
		this.initControlsMenu();
		this.menuBar.add(this.controlsMenu);
		if (this.play.isEmpty()) {
			this.controlsMenu.setEnabled(false);
		}

		this.helpMenu = new JMenu(this.resourceManager
				.getValue("menu.help.text"));
		this.initHelpMenu();
		this.menuBar.add(this.helpMenu);

		if (!Application.isStandAlone()) {
			this.setJMenuBar(this.menuBar);
		}
	}

	protected void initPlayMenu() {
		this.playMenu = new JMenu(this.resourceManager
				.getValue("menu.play.text"));

		this.newMenuItem = new JMenuItem();
		this.newMenuItem
				.setText(this.resourceManager.getValue("play.new.text"));
		this.newMenuItem.setToolTipText(this.resourceManager
				.getValue("play.new.tooltip"));
		this.newMenuItem.setMnemonic(this.resourceManager.getValue(
				"play.new.mnemonic").charAt(0));
		this.newMenuItem.setAccelerator(KeyStroke
				.getKeyStroke(this.resourceManager
						.getValue("play.new.keystroke")));
		this.newMenuItem.addActionListener(NewPlayListener.getNewPlayManager());
		this.playMenu.add(this.newMenuItem);

		this.openMenuItem = new JMenuItem();
		this.openMenuItem.setText(this.resourceManager
				.getValue("play.open.text"));
		this.openMenuItem.setToolTipText(this.resourceManager
				.getValue("play.open.tooltip"));
		this.openMenuItem.setMnemonic(this.resourceManager.getValue(
				"play.open.mnemonic").charAt(0));
		this.openMenuItem.setAccelerator(KeyStroke
				.getKeyStroke(this.resourceManager
						.getValue("play.open.keystroke")));
		this.openMenuItem.addActionListener(OpenPlayListener
				.getOpenPlayManager());
		this.playMenu.add(this.openMenuItem);

		this.openRecentMenuItem = new JMenuItem();
		this.createOpenRecentSubMenu();
		// playMenu.add(openRecentSubMenu);

		this.closeMenuItem = new JMenuItem();
		this.closeMenuItem.setText(this.resourceManager
				.getValue("play.close.text"));
		this.closeMenuItem.setToolTipText(this.resourceManager
				.getValue("play.close.tooltip"));
		this.closeMenuItem.setMnemonic(this.resourceManager.getValue(
				"play.close.mnemonic").charAt(0));
		this.closeMenuItem.setAccelerator(KeyStroke
				.getKeyStroke(this.resourceManager
						.getValue("play.close.keystroke")));
		// playMenu.add(closeMenuItem);
		if (this.play.isEmpty()) {
			this.closeMenuItem.setEnabled(false);
		}

		this.saveMenuItem = new JMenuItem();
		this.saveMenuItem.setText(this.resourceManager
				.getValue("play.save.text"));
		this.saveMenuItem.setToolTipText(this.resourceManager
				.getValue("play.save.tooltip"));
		this.saveMenuItem.setMnemonic(this.resourceManager.getValue(
				"play.save.mnemonic").charAt(0));
		this.saveMenuItem.setAccelerator(KeyStroke
				.getKeyStroke(this.resourceManager
						.getValue("play.save.keystroke")));
		this.saveMenuItem.addActionListener(new SavePlayListener());
		// this.playMenu.add(this.saveMenuItem);
		if (this.play.isEmpty()) {
			this.saveMenuItem.setEnabled(false);
		}

		this.saveAsMenuItem = new JMenuItem();
		this.saveAsMenuItem.setText(this.resourceManager
				.getValue("play.saveas.text"));
		this.saveAsMenuItem.setToolTipText(this.resourceManager
				.getValue("play.saveas.tooltip"));
		this.saveAsMenuItem.setMnemonic(this.resourceManager.getValue(
				"play.saveas.mnemonic").charAt(0));
		// saveAsMenuItem.addActionListener(new SaveAsListener());
		// playMenu.add(saveAsMenuItem);
		if (this.play.isEmpty()) {
			this.saveAsMenuItem.setEnabled(false);
		}

		this.playMenu.addSeparator();

		this.exportMenuItem = new JMenuItem();
		this.exportMenuItem.setText(this.resourceManager
				.getValue("play.export.text"));
		this.exportMenuItem.setToolTipText(this.resourceManager
				.getValue("play.export.tooltip"));
		this.exportMenuItem.setMnemonic(this.resourceManager.getValue(
				"play.export.mnemonic").charAt(0));
		this.exportMenuItem.setAccelerator(KeyStroke
				.getKeyStroke(this.resourceManager
						.getValue("play.export.keystroke")));
		this.exportMenuItem.addActionListener(new GenerateListener(this));
		playMenu.add(exportMenuItem);
		if (this.play.isEmpty()) {
			this.exportMenuItem.setEnabled(false);
		}

		// playMenu.addSeparator();

		this.quitMenuItem = new JMenuItem();
		this.quitMenuItem.setText(this.resourceManager
				.getValue("play.quit.text"));
		this.quitMenuItem.setToolTipText(this.resourceManager
				.getValue("play.quit.tooltip"));
		this.quitMenuItem.setMnemonic(this.resourceManager.getValue(
				"play.quit.mnemonic").charAt(0));
		this.quitMenuItem.setAccelerator(KeyStroke
				.getKeyStroke(this.resourceManager
						.getValue("play.quit.keystroke")));
		this.quitMenuItem.addActionListener(new QuitListener());
		this.playMenu.add(this.quitMenuItem);
	}

	protected void initMediaMenu() {
		this.imagesMenuItem = new JMenuItem();
		this.imagesMenuItem.setText(this.resourceManager
				.getValue("media.images.text"));
		this.imagesMenuItem.setToolTipText(this.resourceManager
				.getValue("media.images.tooltip"));
		this.imagesMenuItem.setMnemonic(this.resourceManager.getValue(
				"media.images.mnemonic").charAt(0));
		this.imagesMenuItem.setAccelerator(KeyStroke
				.getKeyStroke(this.resourceManager
						.getValue("media.images.keystroke")));
		if (!Application.isApplet()) {
			this.imagesMenuItem.addActionListener(new LoadImageListener());
		}
		this.mediaMenu.add(this.imagesMenuItem);

		this.audioMenuItem = new JMenuItem();
		this.audioMenuItem.setText(this.resourceManager
				.getValue("media.audio.text"));
		this.audioMenuItem.setToolTipText(this.resourceManager
				.getValue("media.audio.tooltip"));
		this.audioMenuItem.setMnemonic(this.resourceManager.getValue(
				"media.audio.mnemonic").charAt(0));
		this.audioMenuItem.setAccelerator(KeyStroke
				.getKeyStroke(this.resourceManager
						.getValue("media.audio.keystroke")));
		if (!Application.isApplet()) {
			this.audioMenuItem.addActionListener(new LoadSoundListener());
		}
		this.mediaMenu.add(this.audioMenuItem);
	}

	protected void initHelpMenu() {
		this.manualMenuItem = new JMenuItem();
		this.manualMenuItem.setText(this.resourceManager
				.getValue("help.manual.text"));
		this.manualMenuItem.setToolTipText(this.resourceManager
				.getValue("help.manual.tooltip"));
		this.manualMenuItem.setMnemonic(this.resourceManager.getValue(
				"help.manual.mnemonic").charAt(0));
		this.manualMenuItem.setAccelerator(KeyStroke
				.getKeyStroke(this.resourceManager
						.getValue("help.manual.keystroke")));
		this.manualMenuItem.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				try {
					Desktop desktop = Desktop.getDesktop();
					desktop.browse(new File("manual/handbuch.htm").toURI());
				} catch (Exception exc) {
					new WebBrowser(PlayFrame.this.resourceManager
							.getValue("browser.manual"), ResourceLoader
							.getFileURL("manual/handbuch.htm"));
				}
			}
		});
		this.helpMenu.add(this.manualMenuItem);

		this.apiMenuItem = new JMenuItem();
		this.apiMenuItem
				.setText(this.resourceManager.getValue("help.api.text"));
		this.apiMenuItem.setToolTipText(this.resourceManager
				.getValue("help.api.tooltip"));
		this.apiMenuItem.setMnemonic(this.resourceManager.getValue(
				"help.api.mnemonic").charAt(0));
		this.apiMenuItem.setAccelerator(KeyStroke
				.getKeyStroke(this.resourceManager
						.getValue("help.api.keystroke")));
		this.apiMenuItem.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				try {
					Desktop desktop = Desktop.getDesktop();
					desktop.browse(new File("api/index.html").toURI());
				} catch (Exception exc) {
					new WebBrowser(PlayFrame.this.resourceManager
							.getValue("browser.manual"), ResourceLoader
							.getFileURL("api/index.html"));
				}
			}
		});
		this.helpMenu.add(this.apiMenuItem);

		this.aboutMenuItem = new JMenuItem();
		this.aboutMenuItem.setText(this.resourceManager
				.getValue("help.about.text"));
		this.aboutMenuItem.setToolTipText(this.resourceManager
				.getValue("help.about.tooltip"));
		this.aboutMenuItem.setMnemonic(this.resourceManager.getValue(
				"help.about.mnemonic").charAt(0));
		this.aboutMenuItem.setAccelerator(KeyStroke
				.getKeyStroke(this.resourceManager
						.getValue("help.about.keystroke")));
		this.aboutMenuItem.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				JOptionPane.showMessageDialog(PlayFrame.this,
						PlayFrame.this.resourceManager.getValue("info.text"),
						PlayFrame.this.resourceManager.getValue("info.title"),
						JOptionPane.PLAIN_MESSAGE);
			}
		});
		this.helpMenu.add(this.aboutMenuItem);
	}

	protected void initControlsMenu() {
		this.runMenuItem = new JMenuItem();
		this.runMenuItem.setText(this.resourceManager
				.getValue("controls.run.text"));
		this.runMenuItem.setToolTipText(this.resourceManager
				.getValue("controls.run.tooltip"));
		this.runMenuItem.setMnemonic(this.resourceManager.getValue(
				"controls.run.mnemonic").charAt(0));
		this.runMenuItem.setAccelerator(KeyStroke
				.getKeyStroke(this.resourceManager
						.getValue("controls.run.keystroke")));
		if (this.play.isEmpty()) {
			this.runMenuItem.setEnabled(false);
		}
		if (CompileManager.getCompileManager().isCompilationRequired()) {
			this.runMenuItem.setEnabled(false);
		}
		this.controlsMenu.add(this.runMenuItem);

		this.stopMenuItem = new JMenuItem();
		this.stopMenuItem.setEnabled(false);
		this.stopMenuItem.setText(this.resourceManager
				.getValue("controls.stop.text"));
		this.stopMenuItem.setToolTipText(this.resourceManager
				.getValue("controls.stop.tooltip"));
		this.stopMenuItem.setMnemonic(this.resourceManager.getValue(
				"controls.stop.mnemonic").charAt(0));
		this.stopMenuItem.setAccelerator(KeyStroke
				.getKeyStroke(this.resourceManager
						.getValue("controls.stop.keystroke")));
		if (this.play.isEmpty()) {
			this.stopMenuItem.setEnabled(false);
		}
		this.controlsMenu.add(this.stopMenuItem);

		this.resetMenuItem = new JMenuItem();
		this.resetMenuItem.setText(this.resourceManager
				.getValue("controls.reset.text"));
		this.resetMenuItem.setToolTipText(this.resourceManager
				.getValue("controls.reset.tooltip"));
		this.resetMenuItem.setMnemonic(this.resourceManager.getValue(
				"controls.reset.mnemonic").charAt(0));
		this.resetMenuItem.setAccelerator(KeyStroke
				.getKeyStroke(this.resourceManager
						.getValue("controls.reset.keystroke")));
		// this.resetMenuItem.addActionListener(new ResetListener());
		if (this.play.isEmpty()) {
			this.resetMenuItem.setEnabled(false);
		}
		if (CompileManager.getCompileManager().isCompilationRequired()) {
			this.resetMenuItem.setEnabled(false);
		}
		this.controlsMenu.add(this.resetMenuItem);
	}

	protected void createOpenRecentSubMenu() {
		this.openRecentSubMenu = new JMenu();
		this.openRecentSubMenu.setText(this.resourceManager
				.getValue("play.openrecent.text"));

		this.recent1 = new JMenuItem();
		this.recent1.setText("Recent 1");
		this.openRecentSubMenu.add(this.recent1);

		this.recent2 = new JMenuItem();
		this.recent2.setText("Recent 2");
		this.openRecentSubMenu.add(this.recent2);
	}

	protected void initToolBar() {
		this.toolBar = new JToolBar();
		this.toolBar.setBackground(new Color(255, 215, 180));

		this.newButton = new JButton(ResourceLoader.getImageIcon("New24.gif"));
		this.newButton.setToolTipText(this.resourceManager
				.getValue("play.toolbar.new"));
		this.newButton.setMargin(new Insets(0, 0, 0, 0));
		this.newButton.addActionListener(NewPlayListener.getNewPlayManager());

		if (!Application.isStandAlone()) {
			this.toolBar.add(this.newButton);
		}

		this.openButton = new JButton(ResourceLoader.getImageIcon("Open24.gif"));
		this.openButton.setToolTipText(this.resourceManager
				.getValue("play.toolbar.open"));
		this.openButton.setMargin(new Insets(0, 0, 0, 0));
		this.openButton
				.addActionListener(OpenPlayListener.getOpenPlayManager());
		if (!Application.isStandAlone()) {
			this.toolBar.add(Box.createRigidArea(new Dimension(2, 2)));
			this.toolBar.add(this.openButton);
		}

		this.saveButton = new JButton(ResourceLoader.getImageIcon("Save24.gif"));
		this.saveButton.setToolTipText(this.resourceManager
				.getValue("play.toolbar.save"));
		this.saveButton.setMargin(new Insets(0, 0, 0, 0));
		this.saveButton.addActionListener(new SavePlayListener());
		this.toolBar.add(Box.createRigidArea(new Dimension(2, 2)));
		// this.toolBar.add(this.saveButton);
		if (this.play.isEmpty()) {
			this.saveButton.setEnabled(false);
		}

		if (!Application.isStandAlone()) {
			this.toolBar.add(Box.createRigidArea(new Dimension(11, 11)));
		}

		this.compileButton = new JButton(ResourceLoader
				.getImageIcon("Compile24.gif"));
		this.compileBackgroundColor = this.compileButton.getBackground();
		this.setCompiled(!CompileManager.getCompileManager()
				.isCompilationRequired());
		this.compileButton.setToolTipText(this.resourceManager
				.getValue("play.toolbar.compile"));
		this.compileButton.setMargin(new Insets(0, 0, 0, 0));
		this.compileButton
				.addActionListener(CompileManager.getCompileManager());
		if (!Application.isStandAlone()) {
			this.toolBar.add(this.compileButton);
		}
		if (this.play.isEmpty()) {
			this.compileButton.setEnabled(false);
		}

		this.infoButton = new JButton(ResourceLoader
				.getImageIcon("Information24.gif"));
		this.infoButton.setToolTipText(this.resourceManager
				.getValue("play.toolbar.info"));
		this.infoButton.setMargin(new Insets(0, 0, 0, 0));
		this.toolBar.add(Box.createRigidArea(new Dimension(2, 2)));
		this.infoButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				Editor editor = PlayFrame.this.play.getInfoEditor();
				if (!editor.isOpen()) {
					Point p = ((JComponent) e.getSource())
							.getLocationOnScreen();
					editor.setLocation(Math
							.max(20, p.x - editor.getWidth() / 2), Math.max(20,
							p.y - editor.getHeight() / 2));
					editor.open();
				}
				editor.toFront();
			}
		});
		this.toolBar.add(this.infoButton);
		if (this.play.isEmpty()) {
			this.infoButton.setEnabled(false);
		}

		this.toolBar.add(Box.createRigidArea(new Dimension(11, 11)));

		this.runButton = new JButton(ResourceLoader.getImageIcon("Run24.gif"));
		this.runButton.setToolTipText(this.resourceManager
				.getValue("play.toolbar.run"));
		this.runButton.setMargin(new Insets(0, 0, 0, 0));
		this.toolBar.add(this.runButton);
		if (this.play.isEmpty()) {
			this.runButton.setEnabled(false);
		} else if (CompileManager.getCompileManager().isCompilationRequired()) {
			this.runButton.setEnabled(false);
		}

		this.stopButton = new MyButton(ResourceLoader
				.getImageIcon("Stop24.gif"));
		this.stopButton.setEnabled(false);
		this.stopButton.setToolTipText(this.resourceManager
				.getValue("play.toolbar.stop"));
		this.stopButton.setMargin(new Insets(0, 0, 0, 0));
		this.toolBar.add(Box.createRigidArea(new Dimension(2, 2)));
		this.toolBar.add(this.stopButton);
		if (this.play.isEmpty()) {
			this.stopButton.setEnabled(false);
		}

		this.resetButton = new JButton(ResourceLoader
				.getImageIcon("StepBack24.gif"));
		this.resetButton.setToolTipText(this.resourceManager
				.getValue("play.toolbar.reset"));
		this.resetButton.setMargin(new Insets(0, 0, 0, 0));
		// this.resetButton.addActionListener(new ResetListener());
		this.toolBar.add(Box.createRigidArea(new Dimension(2, 2)));
		this.toolBar.add(this.resetButton);
		if (this.play.isEmpty()) {
			this.resetButton.setEnabled(false);
		} else if (CompileManager.getCompileManager().isCompilationRequired()) {
			this.resetButton.setEnabled(false);
		}

		this.speedSlider = new JSlider(SwingConstants.HORIZONTAL,
				Performance.MIN_SPEED, Performance.MAX_SPEED, play
						.getActivePerformance().getSimulationSpeed());
		this.speedSlider.setBackground(this.toolBar.getBackground());
		this.speedSlider.setToolTipText(this.resourceManager
				.getValue("play.toolbar.speed"));
		this.speedSlider.setMajorTickSpacing(50);
		this.speedSlider.setMinorTickSpacing(25);
		this.speedSlider.setPaintTicks(true);
		this.speedSlider.setPaintLabels(false);
		this.speedSlider.setSnapToTicks(false);
		this.speedSlider.setMaximumSize(new Dimension(200, 50));
		this.speedSlider.setMinimumSize(new Dimension(100, 50));
		this.speedSlider.addChangeListener(new SpeedListener(this.speedSlider));
		this.toolBar.add(Box.createRigidArea(new Dimension(11, 11)));
		this.toolBar.add(this.speedSlider);
		if (this.play.isEmpty()) {
			this.speedSlider.setEnabled(false);
		}

		this.add(this.toolBar, java.awt.BorderLayout.NORTH);
	}

	public int getSpeed() {
		return this.speedSlider.getValue();
	}

	public void setSpeed(int newSpeed) {
		if (this.speedSlider.getValue() != newSpeed) {
			this.speedSlider.setValue(newSpeed);
		}
	}

	protected void initFileTree() {
		this.fileTreeSurrounding = new JPanel();
		this.fileTreeSurrounding.setLayout(new BorderLayout());
		this.fileTreeSurrounding.add(
				Box.createRigidArea(new Dimension(12, 12)), BorderLayout.NORTH);
		this.fileTreeSurrounding.add(
				Box.createRigidArea(new Dimension(12, 12)), BorderLayout.SOUTH);
		this.fileTreeSurrounding.add(
				Box.createRigidArea(new Dimension(12, 12)), BorderLayout.WEST);
		this.fileTreeSurrounding.add(
				Box.createRigidArea(new Dimension(12, 12)), BorderLayout.EAST);

		DefaultMutableTreeNode root = new DirectoryTreeNode(Play.CLASSES);
		DefaultMutableTreeNode worldNode = new DirectoryTreeNode(Play.STAGE);
		root.add(worldNode);
		for (String className : this.play.getStageClasses()) {
			DefaultMutableTreeNode cNode = new DefaultMutableTreeNode(className);
			worldNode.add(cNode);
		}

		DefaultMutableTreeNode actorNode = new DirectoryTreeNode(Play.ACTOR);
		root.add(actorNode);
		for (String className : this.play.getActorClasses()) {
			DefaultMutableTreeNode cNode = new DefaultMutableTreeNode(className);
			actorNode.add(cNode);
		}

		DefaultMutableTreeNode propNode = new DirectoryTreeNode(Play.PROP);
		root.add(propNode);
		for (String className : this.play.getPropClasses()) {
			DefaultMutableTreeNode cNode = new DefaultMutableTreeNode(className);
			propNode.add(cNode);
		}

		DefaultMutableTreeNode performanceNode = new DirectoryTreeNode(
				Play.PERFORMANCE);
		root.add(performanceNode);
		for (String className : this.play.getPerformanceClasses()) {
			DefaultMutableTreeNode cNode = new DefaultMutableTreeNode(className);
			performanceNode.add(cNode);
		}

		DefaultMutableTreeNode otherNode = new DirectoryTreeNode(Play.OTHER);
		root.add(otherNode);
		for (String className : this.play.getOtherClasses()) {
			DefaultMutableTreeNode cNode = new DefaultMutableTreeNode(className);
			otherNode.add(cNode);
		}

		DefaultTreeModel treeModel = new DefaultTreeModel(root);
		this.fileTree = new FileTree(treeModel);
		this.fileTree.setBackground(new Color(240, 252, 202));
		TreeSelectionModel tsm = new DefaultTreeSelectionModel();

		/*
		 * ImageIcon leafIcon =
		 * ResourcesLoader.getImageIcon("StartPicture.png"); if (leafIcon !=
		 * null) { DefaultTreeCellRenderer renderer = new
		 * DefaultTreeCellRenderer(); renderer.setLeafIcon(leafIcon);
		 * fileTree.setCellRenderer(renderer); }
		 */

		this.fileTree.setCellRenderer(new FileTreeCellRenderer());
		tsm.setSelectionMode(TreeSelectionModel.SINGLE_TREE_SELECTION);
		this.fileTree.setSelectionModel(tsm);
		this.fileTree.setRootVisible(true);
		this.fileTree.setBorder(BorderFactory.createEmptyBorder());
		if (this.play.isEmpty()) {
			this.fileTree.setEnabled(false);
		} else {
			this.dirPopupMenu = new DirectoryPopupMenu(this.fileTree);
			MouseListener popupListener = new FileTreePopupListener(
					this.dirPopupMenu, this.fileTree);
			this.fileTree.addMouseListener(popupListener);
		}

		this.fileTreeSurrounding.setBackground(this.fileTree.getBackground());
		this.fileTreeSurrounding.add(this.fileTree, BorderLayout.CENTER);

		if (!Application.isStandAlone()) {
			Collection<TheaterClass> coll = ClassManager.getClassManager()
					.getAllClasses();
			for (TheaterClass cls : coll) {
				cls.getEditor().addObserver(this.fileTree);
			}
		}
	}

	protected void initStage() {
		this.stage = new StagePanel(this.play);
	}

	protected void initMessagePanel() {
		this.messagePanel = new MessagePanel(ResourceManager
				.getResourceManager().getValue("msg.welcome")
				+ " - " + Utils.getVersion());
	}

	protected void handleSimulation() {
		this.simulationManager = new ActSimulationManager(this.runButton,
				this.stopButton, this.resetButton, this.runMenuItem,
				this.stopMenuItem, this.resetMenuItem);
		SimulationManager.setSimulationManager(this.simulationManager);
		this.runButton.addActionListener(this.simulationManager);
		this.stopButton.addActionListener(this.simulationManager);
		this.resetButton.addActionListener(this.simulationManager);
		this.runMenuItem.addActionListener(this.simulationManager);
		this.stopMenuItem.addActionListener(this.simulationManager);
		this.resetMenuItem.addActionListener(this.simulationManager);

		if (this.play.isEmpty()) {
			this.runButton.setEnabled(false);
			this.stopButton.setEnabled(false);
			this.resetButton.setEnabled(false);
		}
	}

	public void setCompiled(boolean state) {
		this.compiled = state;
		if (this.compiled) {
			this.compileButton.setBackground(this.compileBackgroundColor);
		} else {
			this.compileButton.setBackground(new Color(255, 100, 100));
		}
	}

	public void windowActivated(WindowEvent e) {

	}

	public void windowClosed(WindowEvent e) {
		// new QuitListener().quit();
	}

	public void windowClosing(WindowEvent e) {
		QuitListener.quit();
	}

	public void windowDeactivated(WindowEvent e) {

	}

	public void windowDeiconified(WindowEvent e) {

	}

	public void windowIconified(WindowEvent e) {

	}

	public void windowOpened(WindowEvent e) {

	}

	public void update(Observable o, Object arg) {
		boolean required = CompileManager.getCompileManager()
				.isCompilationRequired();
		this.setCompiled(!required);
		if (required) {
			this.exportMenuItem.setEnabled(false);
		} else {
			this.exportMenuItem.setEnabled(true);
		}
	}

	public JToolBar getToolBar() {
		return toolBar;
	}
}
