package data;

import theater.*;

import java.awt.Font;

/**
 * bertragen aus dem Greenfoot-Szenario balloons
 * <p>
 * </p>
 * Counter that displays a number.
 */
public class Counter extends Actor {
	private int value = 0;
	private int target = 0;
	private String text;
	private int stringLength;

	public Counter() {
		this("");
	}

	public Counter(String prefix) {
	     setZCoordinate(4);
		text = prefix;
		stringLength = (text.length() + 2) * 16;

		setImage(new TheaterImage(stringLength, 24));
		TheaterImage image = getImage();
		Font font = image.getFont();
		image.setFont(font.deriveFont(24.0F)); // use larger font

		updateImage();
	}

	public void run() {
		if (value < target) {
			value++;
			updateImage();
		} else if (value > target) {
			value--;
			updateImage();
		}
	}

	public void add(int score) {
		target += score;
	}

	public void subtract(int score) {
		target -= score;
	}

	public int getValue() {
		return value;
	}

	/**
	 * Make the image
	 */
	private void updateImage() {
		TheaterImage image = getImage();
		image.clear();
		image.drawString(text + value, 1, 18);
	}
}
