package model;

import java.io.File;

import listener.Application;

import compiler.CompileManager;

import theater.TheaterImage;
import editor.JavaEditor;

/**
 * Reprsentiert eine Klasse eines Theater-Stcks
 * 
 * @author Dietrich Boles, Uni Oldenburg
 * @version 1.0 (12.11.2008)
 * 
 */
public class TheaterClass {

	private String name;
	private Class<?> father;
	private TheaterImage image;
	private JavaEditor editor;

	/**
	 * Erzeugt eine neue Klasse. Angegeben werden der Name sowie die
	 * Theater-Oberklasse (Stage, Actor, Prop, ...)
	 * 
	 * @param name
	 * @param father
	 */
	public TheaterClass(String name, Class<?> father, Play play) {
		this.name = name;
		this.father = father;
		this.image = new TheaterImage(father);
		if (!Application.isStandAlone()) {
			this.editor = new JavaEditor(play.getDirectory()
					+ File.separatorChar + name + ".java", play.getName());
			this.editor.addObserver(CompileManager.getCompileManager());
			if (play.getPlayFrame() != null) {
				this.editor.addObserver(play.getPlayFrame().getFileTree());
			}
		}
	}

	/**
	 * Liefert das der Klasse zugeordnete Image
	 * 
	 * @return
	 */
	public TheaterImage getImage() {
		return this.image;
	}

	/**
	 * Ordnet der Klasse ein neues Image zu
	 * 
	 * @param image
	 */
	public void setImage(TheaterImage image) {
		this.image = image;
	}

	/**
	 * Liefert den Namen der Klasse
	 * 
	 * @return
	 */
	public String getName() {
		return this.name;
	}

	/**
	 * Liefert die Theater-Oberklasse der Klasse
	 * 
	 * @return
	 */
	public Class<?> getFather() {
		return this.father;
	}

	/**
	 * liefert den zugeordneten Editor
	 * 
	 * @return
	 */
	public JavaEditor getEditor() {
		return editor;
	}
}
