package theater;

import model.Play;

/**
 * Die Klasse CellArea reprsentiert ein Menge von Zellen (genauer ein
 * rechteckiges Gebiet von Zellen) der Bhne. Sie implementiert das Interface
 * PixelArea, so dass mit dieser Klasse Kollisionen von Zellen mit anderen
 * Gebieten der Bhne berprft werden knnen.
 * 
 * @author Dietrich Boles, Universitt Oldenburg, Germany
 * @version 1.0 (08.09.2009)
 * 
 */
public class CellArea implements PixelArea {

	/**
	 * Spalte der linken oberen Ecke des CellArea-Gebietes
	 */
	protected int fromCol;

	/**
	 * Reihe der linken oberen Ecke des CellArea-Gebietes
	 */
	protected int fromRow;

	/**
	 * Breite, d.h. Anzahl an Spalten des CellArea-Gebietes
	 */
	protected int numberOfCols;

	/**
	 * Hhe, d.h. Anzahl an Spalten des CellArea-Gebietes
	 */
	protected int numberOfRows;

	/**
	 * Konstruktor zum Initialisieren der CellArea.
	 * 
	 * @param fromCol
	 *            Spalte der linken oberen Ecke des CellArea-Gebietes
	 * @param fromRow
	 *            Reihe der linken oberen Ecke des CellArea-Gebietes
	 * @param numberOfCols
	 *            Breite, d.h. Anzahl an Spalten des CellArea-Gebietes
	 * @param numberOfRows
	 *            Hhe, d.h. Anzahl an Spalten des CellArea-Gebietes
	 */
	public CellArea(int fromCol, int fromRow, int numberOfCols, int numberOfRows) {
		this.fromCol = fromCol;
		this.fromRow = fromRow;
		this.numberOfCols = numberOfCols;
		this.numberOfRows = numberOfRows;
	}

	/**
	 * berprft, ob der Punkt mit den als Parameter bergebenen Koordinaten
	 * innerhalb der aufgerufenen CellArea liegt.
	 * 
	 * @param x
	 *            x-Koordinate des Punktes
	 * @param y
	 *            y-Koordinate des Punktes
	 * @return genau dann true, wenn der Punkt mit den als Parameter bergebenen
	 *         Koordinaten innerhalb der aufgerufenen CellArea liegt
	 * 
	 * @see theater.PixelArea#contains(int, int)
	 */
	public boolean contains(int x, int y) {
		java.awt.Rectangle rect = Play.getPlay().getStagePanel()
				.getCellRectangle(this.fromRow, this.fromCol);
		return new Rectangle(rect.x, rect.y, rect.width * this.numberOfCols,
				rect.height * this.numberOfRows).contains(x, y);
	}

	/**
	 * berprft, ob die aufgerufene CellArea komplett innerhalb der als
	 * Parameter bergebenen PixelArea liegt.
	 * 
	 * @param area
	 *            die zu vergleichende PixelArea
	 * @return genau dann true, wenn die aufgerufene CellArea komplett innerhalb
	 *         der als Parameter bergebenen PixelArea liegt
	 * 
	 * @see theater.PixelArea#isInside(theater.PixelArea)
	 */
	public boolean isInside(PixelArea area) {
		java.awt.Rectangle rect = Play.getPlay().getStagePanel()
				.getCellRectangle(this.fromRow, this.fromCol);
		return new Rectangle(rect.x, rect.y, rect.width * this.numberOfCols,
				rect.height * this.numberOfRows).isInside(area);
	}

	/**
	 * berprft, ob die aufgerufene CellArea die als Parameter bergebene
	 * PixelArea schneidet.
	 * 
	 * @param area
	 *            die zu vergleichende PixelArea
	 * @return genau dann true, wenn die aufgerufene CellArea die als Parameter
	 *         bergebene PixelArea schneidet
	 * @see theater.PixelArea#intersects(theater.PixelArea)
	 */
	public boolean intersects(PixelArea area) {
		java.awt.Rectangle rect = Play.getPlay().getStagePanel()
				.getCellRectangle(this.fromRow, this.fromCol);
		return new Rectangle(rect.x, rect.y, rect.width * this.numberOfCols,
				rect.height * this.numberOfRows).intersects(area);
	}

	/**
	 * Liefert die Spalte der linken oberen Ecke der CellArea.
	 * 
	 * @return die Spalte der linken oberen Ecke der CellArea
	 */
	public int getFromCol() {
		return this.fromCol;
	}

	/**
	 * Liefert die Reihe der linken oberen Ecke der CellArea.
	 * 
	 * @return die Reihe der linken oberen Ecke der CellArea
	 */
	public int getFromRow() {
		return this.fromRow;
	}

	/**
	 * Liefert die Breite, d.h. die Anzahl an Spalten der CellArea.
	 * 
	 * @return die Anzahl an Spalten der CellArea
	 */
	public int getNumberOfCols() {
		return this.numberOfCols;
	}

	/**
	 * Liefert die Hhe, d.h. die Anzahl an Reihen der CellArea.
	 * 
	 * @return die Anzahl an Reihen der CellArea
	 */
	public int getNumberOfRows() {
		return this.numberOfRows;
	}

}
